# -*- coding: UTF-8 -*-
import traceback

from common.commonFunction import get_title_from_xm_info
from common.log import Log
from common.result import set_result_fail
from frame.context.contextUtil import get_item
from funcFactory.dataCollectUtil import collect_data


def execute(context):
    try:
        # 构造收集项的title
        set_title_data(context)
        # 构造收集项的收集数据
        return set_ret_data(context)
    except Exception as ex:
        Log.error("Failed to execute collectStandard file, because %s", str(traceback.format_exc()))
        return set_result_fail(context, "collect.standard.fail.errMsg")


def set_title_data(context):
    cmd4_excel = get_item(context, "cmd4Excel")
    title_list_map = get_title_from_xm_info(cmd4_excel)
    context["titleListMap"] = title_list_map


def set_ret_data(context):
    cmd4_excel = get_item(context, "cmd4Excel")
    (code, ret_data_map, all_err_msg) = collect_data(context, cmd4_excel)
    context["retDataMap"] = ret_data_map
    return (code, all_err_msg)
