# -*- coding: UTF-8 -*-

import os
import traceback

from common.commonFunction import excute_cmd
from common.constant import CMD
from common.log import Log
from common.result import set_result_fail, set_result_succ
from common.xmlParser import parseXMLFile
from frame.cli.cliUtil import get_vertical_cli_ret
from frame.context.contextUtil import set_item


def execute(context):
    """
    @summary: 框架默认入口函数
    """
    try:
        init_log(context)

        if not can_exec_cli_cmd(context):
            return set_result_fail(context, "systemStatus.abmormal.errMsg")

        # 解析标准收集项的配置文件
        (is_success, cmd4_ibm_sxml_info) = parse_cmd4_ibm_sxml_file(context)
        if not is_success:
            return set_result_fail(context, "parse.xml.cmdxml.fail.errMsg")
        else:
            set_item(context, "cmd4IBMS", cmd4_ibm_sxml_info)
        Log.error(context)
    except Exception as ex:
        Log.error("Failed to execute prepare file, because %s" % str(traceback.format_exc()))
        Log.error(context)
        return set_result_fail(context, "prepare.fail.errMsg")

    return set_result_succ()


def init_log(context):
    Log(context)


def parse_cmd4_ibm_sxml_file(context):
    is_success = True
    cmd4_ibm_sxml_info = None
    try:
        cmd4_ibm_sxml_file = os.path.join(context.get("path"), "script", "config", "cmd4IBMS.xml")
        cmd4_ibm_sxml_info = parseXMLFile(cmd4_ibm_sxml_file)
    except Exception as ex:
        is_success = False
        Log.error("Failed to parse xml file, because %s" % str(traceback.format_exc()))
    return (is_success, cmd4_ibm_sxml_info)


def can_exec_cli_cmd(context):
    (_, cli_ret, _) = excute_cmd(context, CMD.SHOW_SYSTEM_GENERAL)
    get_vertical_cli_ret(cli_ret)
    return True
