# -*- coding: UTF-8 -*-
from frame.cli.cliUtil import execute_cmd_in_cli_mode, execute_cmd_in_developer_mode
from frame.context.contextUtil import init_cli_connection, get_cli, get_lang


def excute_cmd(context, command):
    init_cli_connection(context)
    cli = get_cli(context)
    lang = get_lang(context)
    return execute_cmd_in_cli_mode(cli, command, True, lang)


def excute_cmd_in_developer(context, command):
    init_cli_connection(context)
    cli = get_cli(context)
    lang = get_lang(context)
    return execute_cmd_in_developer_mode(cli, command, True, lang)


def add_collect_text(attr_nodes, std_item_title_list):
    for attr_node in attr_nodes:
        collect_text = attr_node["elementText"]
        std_item_title_list.append(collect_text)


def get_title_from_xm_info(xm_info):
    """
    @summary: 从xml信息中解析出收集项中对应的cli回显中的字段
    @param xm_info: 解析xml后的信息(一个嵌套的字典)
    @return: 收集项的title（一个字典列表）
    """
    std_item_title_list_map = {}
    collect_item_nodes = xm_info["elementChildEles"]

    for collect_item_node in collect_item_nodes:
        collect_item_name = collect_item_node["elementAttrbutes"]["name"]
        cmd_nodes = collect_item_node["elementChildEles"]

        std_item_title_list = []
        for cmd_node in cmd_nodes:
            if cmd_node["elementName"] != "cmd":
                continue

            attrs_node = cmd_node["elementChildEles"][0]
            attr_nodes = attrs_node["elementChildEles"]
            add_collect_text(attr_nodes)

        std_item_title_list_map[collect_item_name] = std_item_title_list

    return std_item_title_list_map
