# -*- coding: UTF-8 -*-
from common.constant import SCRIPT_RET_CODE
from common.log import Log
from frame.context.contextUtil import get_resource


def set_result_fail(context, err_msg, err_param=None):
    err_msg = get_err_msg_from_language_file(context, err_msg, err_param)
    return SCRIPT_RET_CODE.FAIL, err_msg


def set_result_succ():
    return SCRIPT_RET_CODE.SUCCESS, ""


def set_result_part_succ(context, err_msg, err_param=None):
    err_msg = get_err_msg_from_language_file(context, err_msg, err_param)
    return SCRIPT_RET_CODE.PART_SUCCESS, err_msg


def get_err_msg_from_language_file(context, err_msg_key, err_param=None):
    lang = context["lang"]
    err_msg = get_resource(context, lang, err_msg_key)
    try:
        if err_param is not None:
            err_msg = err_msg % err_param
    except Exception as e:
        Log.error("Failed to get error message from language file: %s" % e)
    return err_msg
