# -*- coding: UTF-8 -*-

from common.log import Log


class CliConnection:
    RE_CONNECTION_TIMES = 3
    _instance = None
    _cli = None

    def __new__(cls, *args, **kwargs):
        if cls._instance is None:
            cls._instance = super(CliConnection, cls).__new__(cls, *args, **kwargs)
        return cls._instance

    def __init__(self, connector_factory, ip, ssh_port):
        self.connectorFactory = connector_factory
        self.ip = ip
        self.sshPort = ssh_port

    def create(self, user, pawd):
        re_connection_times = 0
        while self._cli is None and re_connection_times < CliConnection.RE_CONNECTION_TIMES:
            ssh_connector = self.connectorFactory.createSshConnector(self.ip, self.sshPort, user, pawd)
            self._cli = ssh_connector.getConnectionNoException()
            re_connection_times += 1
        del pawd
        return self._cli

    def close(self):
        if self._cli is not None:
            try:
                self._cli.close()
            except Exception as err:
                Log.error("Failed to do _cli.close(): %s" % err)
                return None
            finally:
                self._cli = None
        return None

    def get_cli(self, user, pawd):
        if self._cli is None:
            self.create(user, pawd)
        del pawd
        return self._cli
