# -*- coding: UTF-8 -*-
import os

from frame.cli.cliFactory import CliConnection

SCRIPT_DEF_CONTEXT = "SCRIPT_DEF_CONTEXT"
RESOURCE_DEF_CONTEXT = "RESOURCE_DEF_CONTEXT"

CLI_CONNECTION = "CLI_CONNECTION"
TLV_CONNECTION = "TLV_CONNECTION"


def get_lang(context):
    return context["lang"]


def get_script_def_dict(context):
    if isinstance(context, dict):
        if not context.has_key(SCRIPT_DEF_CONTEXT):
            context.setdefault(SCRIPT_DEF_CONTEXT, {})
    else:
        if not context.containsKey(SCRIPT_DEF_CONTEXT):
            context.put(SCRIPT_DEF_CONTEXT, {})
    return context.get(SCRIPT_DEF_CONTEXT)


def get_resource_dict(context, lang):
    script_def_dict = get_script_def_dict(context)
    if not script_def_dict.has_key(RESOURCE_DEF_CONTEXT):
        resource_file_path = get_resource_path(context, lang)
        resource_file = open(resource_file_path)
        contents = resource_file.read().splitlines()
        resource_dict = {}
        for line in contents:
            fields = line.split("=")
            if len(fields) < 2:
                continue

            key = fields[0].strip()
            value = "=".join(fields[1:]).strip().decode('utf-8', 'ignore')
            resource_dict.setdefault(key, value)
        script_def_dict.setdefault(RESOURCE_DEF_CONTEXT, resource_dict)

    return script_def_dict.get(RESOURCE_DEF_CONTEXT)


def set_item(context, key, value):
    script_def_dict = get_script_def_dict(context)
    script_def_dict.setdefault(key, value)

    if isinstance(context, dict):
        context.setdefault(SCRIPT_DEF_CONTEXT, script_def_dict)
    else:
        context.put(SCRIPT_DEF_CONTEXT, script_def_dict)
    return


def remove_item(context, key):
    script_def_dict = get_script_def_dict(context)
    script_def_dict.pop(key)
    return


def get_item(context, key):
    script_def_dict = get_script_def_dict(context)
    return script_def_dict.get(key, None)


def get_connector_factory_obj(context):
    return context.get("connectorFactory")


def get_dev_obj(context):
    return context.get("dev")


def init_cli_connection(context):
    connector_factory_obj = get_connector_factory_obj(context)
    dev_obj = get_dev_obj(context)

    ip = dev_obj.getIp()
    ssh_port = int(dev_obj.getPort())

    conn = CliConnection(connector_factory_obj, ip, ssh_port)
    conn.create(dev_obj.getLoginUser().getUserName(), dev_obj.getLoginUser().getPassword())

    set_item(context, CLI_CONNECTION, conn)
    return


def get_cli(context):
    conn = get_item(context, CLI_CONNECTION)
    if conn is None:
        return None

    dev_obj = get_dev_obj(context)
    cli = conn.getCli(dev_obj.getLoginUser().getUserName(), dev_obj.getLoginUser().getPassword())
    return cli


def destroy_cli_connection(context):
    conn = get_item(context, CLI_CONNECTION)
    if conn is not None:
        conn.close()
        remove_item(context, CLI_CONNECTION)
    return


def init_tlv_connection(context):
    connector_factory_obj = get_connector_factory_obj(context)
    dev_obj = get_dev_obj(context)

    ip = dev_obj.get("ip")
    tlv_port = dev_obj.get("tlvPort")
    user = dev_obj.get("user")

    conn = TlvConnection(connector_factory_obj, ip, tlv_port, user, dev_obj.get("pawd"))
    conn.create()

    set_item(context, TLV_CONNECTION, conn)
    return


def get_tlv(context):
    conn = get_item(context, TLV_CONNECTION)
    if conn is None:
        return None

    tlv = conn.getTlv()
    return tlv


def destroy_tlv_connection(context):
    conn = get_item(context, TLV_CONNECTION)
    if conn is not None:
        conn.close()
        remove_item(context, TLV_CONNECTION)
    return


def set_result(context, flag, err_msg="", suggestion=""):
    context["succ"] = flag
    context["errMsg"] = err_msg
    context["suggestion"] = suggestion
    return


def handle_success(context):
    set_result(context, True)
    return


def handle_failure(context, result_dict):
    flag = result_dict["flag"]
    err_msg = result_dict["errMsg"]
    suggestion = result_dict["suggestion"]
    set_result(context, flag, err_msg, suggestion)
    return


def handle_exception(context):
    lang = get_lang(context)
    err_msg, suggestion = common.getMsg(lang, "query.result.abnormal")
    set_result(context, False, err_msg, suggestion)
    return


def handle_ism_exception(context):
    lang = get_lang(context)
    err_msg, suggestion = common.getMsg(lang, "query.result.abnormal")
    set_result(context, False, err_msg, suggestion)
    return


def get_resource(context, lang, key):
    resource_dict = get_resource_dict(context, lang)
    return resource_dict.get(key, "--")


def get_resource_path(context, lang):
    return os.path.join(get_import_root_dir(context), "script", "res", "language", "resource_%s.ini" % lang)


def get_import_root_dir(context):
    return context.get("path")
