﻿# -*- coding: UTF-8 -*-
import re
from time import sleep
from constant import CmdConstants
from constant import CLI_CMD_Prompt

def execCmd(sshConnector, cmd, logger):
    '''
    Function describe:    Execute CLI command interface.
    Return value:         (boolean, cliRet)    

    Revision History:     1. Created 2014-02-21 
    '''
    
    if not sshConnector or not cmd:
        if logger:
            logger.error('[cliCmdManager]Parameter invalid when execute CLI command!')
        return (False, None)
    if not logger:
        return (False, None)
    
    ssh = sshConnector.getConnectionNoException()
    
    cliRet = ''
    exceptionTimes = 0
    
    while exceptionTimes < CmdConstants.CLI_EXECMD_RETRY_TIMES: 
        try:
            cliRet = ssh.execCmdWithTimout(cmd, CmdConstants.CLI_DEFAULT_TIMEOUT)
        except:
            logger.error('[cliCmdManager]-execute command[' + cmd + '] exception!')
            
            sleep(CmdConstants.CLI_RETRY_INTERVAL_TIME)
            exceptionTimes += 1
            
            logger.warn('[cliCmdManager]Try to get SSH connection again!')
            ssh = sshConnector.getConnectionNoException()
        else:
            cliRetLineList = cliRet.splitlines()
            if not cliRetLineList or re.search(CLI_CMD_Prompt.STORAGE, cliRetLineList[-1], re.IGNORECASE):
                try:
                    ssh.close()
                except:
                    pass
                finally:
                    ssh = sshConnector.getConnectionNoException()
            else:
                logger.info('[cliCmdManager]Execute command[' + cmd + '] successfully, return now!')
                return (True, cliRet)
    else:
        logger.error('[cliCmdManager]Execute command[' + cmd + '] exception 3 times!')
        return (False, cliRet)
    
