# -*-:coding: UTF-8 -*-
import re
import cliCmdManager
from constant import CLI_CMD_Prompt
from constant import TV2R2_CLI_CMD

def changeCli2Developer(sshConnector, devPasswd, logger):
    '''
    Function describe:    Switch CLI mode to developer mode.
    Return value:         boolean--Return True if success, otherwise return False.                            

    Revision History:     1. Created 2014-02-22 
    '''

    ret = cliCmdManager.execCmd(sshConnector, TV2R2_CLI_CMD.SWITCH_TO_DEVELOPER, logger)
    if not ret[0]:
        logger.error('Switch to developer mode failed!')
        return False
    
    temp = ret[1]
    
    ssh = sshConnector.getConnectionNoException()
    if not ssh:
        logger.error('Get SSH connection failed when switching to developer mode.')
        return False
    
    #判断是否已经developer模式
    if re.search("Password", temp, re.IGNORECASE):
        temp = ssh.execCmdNoLogTimout(devPasswd, 180)
        if re.search("developer", temp, re.IGNORECASE):
            return True
    
    #进入developer模式失败，重新回到CLI模式
    exitSshConnection(sshConnector, logger)
    return False

def changeCli2Diagnose(sshConnector, devPasswd, logger):
    '''
    Function describe:    Switch CLI mode to diagnose mode.
    Return value:         boolean--Return True if success, 
                                   otherwise return False.                            

    Revision History:     1. Created 2014-02-22 
    '''    
    
    if not changeCli2Developer(sshConnector, devPasswd, logger):
        logger.error('Switch CLI mode to developer mode failed when switching CLI mode to diagnose mode!')
        return False
    
    ssh = sshConnector.getConnectionNoException()
    if not ssh:
        logger.error('Get SSH connection failed when switching CLI mode to diagnose mode.')
        return False
    
    devRet = ssh.execCmdWithTimout("debug", 10)
    if re.search('diagnose>', devRet, re.IGNORECASE):
        return True
   
    exitSshConnection(sshConnector, logger)
    return False 

def exitSshConnection(sshConnector, logger):
    '''
    Function describe:    Close current SSH connection.
    Return value:         None.                            

    Revision History:     1. Created 2014-02-22 
    '''        
    
    ssh = sshConnector.getConnectionNoException()
    if not ssh:
        logger.error('Get SSH connection failed when closing CLI connection.')
        return 
    
    while True:        
        try:
            ssh.close()
        except :
            logger.warn('Close SSH connection exception, connection maybe closed!')
            return
        else:
            logger.info('Close SSH connection successfully!')
            return
        

def changeDeveloper2Minisystem(sshConnector, logger):
    '''
    Function describe:    Switch developer mode to minisystem mode.
    Return value:         boolean--Return True if success, 
                                   otherwise return False.                            

    Revision History:     1. Created 2014-02-22 
    '''        
  
    ssh = sshConnector.getConnectionNoException()
    if not ssh:
        logger.error('Get SSH connection failed when switching developer mode to minisystem mode.')
        return False
    
    #进入minisystem
    temp = ssh.execCmdWithTimout("minisystem", 5)

    if re.search("minisystem>", temp, re.IGNORECASE):
        return True
    
    if re.search("Are you sure", temp, re.IGNORECASE):
        temp1 = ssh.execCmd("y")

        if re.search("minisystem>", temp1, re.IGNORECASE):
            return True
    
    exitSshConnection(sshConnector, logger)
    return False

def heartbeatToPeer(sshConnector, devPwd, usrPwd, logger):
    '''
    Function describe:    Switch CLI mode to diagnose mode.
    Return value:         boolean--Return True if success, 
                                   otherwise return False.                            

    Revision History:     1. Created 2014-02-22 
    '''  
    ssh = sshConnector.getConnectionNoException()
    if not ssh:
        logger.error('Get SSH connection failed when switch to peer by heartbeat.')
        return False
    
    if changeCliModel2Minisystem(sshConnector, devPwd, logger):
        try:
            temp = ssh.execCmd("sshtoremote")
            if re.search("password:", temp, re.IGNORECASE):
                temp1 = ssh.execCmdNoLogTimout(usrPwd, 60)
                if re.search("You have accessed the system operated", temp1, re.IGNORECASE):
                    return True
            else:
                logger.error('Command sshtoremote result:' + str(temp1))
                exitSshConnection(sshConnector, logger)
                return False
        except BaseException, e:
            logger.error('Execute command sshtoremote exception:' + str(e))
            exitSshConnection(sshConnector, logger)
            return False
    else:
        logger.error('Command sshtoremote result:' + str(temp1))
        exitSshConnection(sshConnector, logger)
        return False
        
def changeSafeModel2Minisystem(sshConnector, logger):
    '''
    Function describe:    Switch safe mode to minisystem mode.
    Return value:         boolean--Return True if success, 
                                   otherwise return False.                            

    Revision History:     1. Created 2014-02-22 
    '''        
    ssh = sshConnector.getConnectionNoException()
    if not ssh:
        logger.error('Get SSH connection failed when switching developer mode to minisystem mode.')
        return False
    
    #直接输入minisystem命令
    temp = ssh.execCmd("minisystem")
    if re.search("minisystem>", temp, re.IGNORECASE):
        return True
    else:
        exitSshConnection(sshConnector, logger)
        return False

    
def changeCliModel2Minisystem(sshConnector, devPasswd, logger):
    '''
    Function describe:    Switch CLI mode to diagnose mode.
    Return value:         boolean--Return True if success, 
                                   otherwise return False.                            

    Revision History:     1. Created 2014-02-22 
    '''
        
    if not changeCli2Developer(sshConnector, devPasswd, logger):
        logger.error('Switch CLI mode to developer mode failed!')
        exitSshConnection(sshConnector, logger)
        return False
        
    if not changeDeveloper2Minisystem(sshConnector, logger):
        logger.error('Switch developer to minisystem mode failed!')
        exitSshConnection(sshConnector, logger)
        return False
    
    logger.info('Switch CLI mode to minisystem mode successfully!')
    return True

