# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2023. All rights reserved.
import json
import re
from com.huawei.ism.tool.obase.entity import EntityUtils
from common import resource

from com.huawei.ism.tool.archivecollect.utils import DistributeDeviceInfoCollect

FAIL = 0
SUCCESS = 1

# LicBusinessModel为'COMM'时对应expiredTime字段返回值
COMM_DEADLINE = ["9999-12-31", "PERMANENT"]

TITLE_DICT = {
    "System": [
        "Product Model",
        "ESN",
        "NE_ID",
        "SN"
        "System Name",
        "Product Version"
    ],
    "License": [
        "License SN",
        "LICENSE ESN",
        "LICENSE SERVICE AUTH TYPE",
        "SoftwareId"
    ],
    "Software":[
        "ESN",
        "Product Version",
        "Product Model",
        "Patch Version"
    ]
}

result_dict = {
    "System": [],
    "License": [],
    "Software": [],
    "Dimension": []
}


def build_sys_info(dev_node):
    return {
        "ESN": dev_node.getDeviceSerialNumber(),
        "Product Version": dev_node.getProductVersion(),
        "Product Model": dev_node.getProductModel(),
        "System Name": dev_node.getDeviceName(),
        "NE_ID": dev_node.getDeviceSerialNumber(),
        "SN": dev_node.getDeviceSerialNumber()
    }


def build_license_info(dev_node, license_info):
    return {
        "License SN": license_info.get("licenseSn", ""),
        "LICENSE ESN": dev_node.getDeviceSerialNumber(),
        "LICENSE SERVICE AUTH TYPE": license_model_info(license_info.get("expiredTime", "")),
        "SoftwareId": 'NA',
    }


def license_model_info(expired_time):
    if expired_time in COMM_DEADLINE:
        return "COMM"
    return "DEMO"


def build_software_info(dev_node):
    show_version = dev_node.getProductVersionToShow()
    match = re.search(r'(SPH|SPC|HP)\w*$', show_version)
    if match:
        return {
            "ESN": dev_node.getDeviceSerialNumber(),
            "Product Version": dev_node.getProductVersion(),
            "Product Model": dev_node.getProductModel(),
            "Patch Version": match.group()
        }
    else:
        return {
            "ESN": dev_node.getDeviceSerialNumber(),
            "Product Version": dev_node.getProductVersion(),
            "Product Model": dev_node.getProductModel(),
        }



def execute(context):
    try:
        dev = EntityUtils.toOldDev(context.get("dev"))

        DistributeDeviceInfoCollect.updateClusterBaseInfo(dev)
        result_dict.get("System").append(build_sys_info(dev))

        license_data = json.loads(DistributeDeviceInfoCollect.queryLicenseListInfo(dev)).get("commonInfo", {})
        result_dict.get("License").append(build_license_info(dev, license_data))

        result_dict.get("Software").append(build_software_info(dev))

        context['titleListMap'] = TITLE_DICT
        context['retDataMap'] = result_dict
        DistributeDeviceInfoCollect.buildClusterNodeXml(dev, context.get("currentDevResultDir"),
                                                        context.get("siteName"))
        return SUCCESS, resource.MESSAGES_DICT.get("collect.success.msg")
    finally:
        DistributeDeviceInfoCollect.releaseConn(EntityUtils.toOldDev(context.get("dev")))
