# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import re
from com.huawei.ism.tool.obase.entity import EntityUtils
from common.resource import Resource

from com.huawei.ism.tool.archivecollect.utils import FusionCubeDeviceInfoCollectUtil

FAIL = 0
SUCCESS = 1

TITLE_DICT = {
    "System": [
        "Product Model",
        "ESN",
        "NE_ID",
        "System Name",
        "Product Version"
    ],
    "License": [
        "License SN",
        "LICENSE ESN",
        "LICENSE SERVICE AUTH TYPE",
        "SoftwareId"
    ]
}

result_dict = {
    "System": [],
    "License": []
}


def execute(context):
    logger = context.get("logger")
    resource = Resource(context)

    file_res = FusionCubeDeviceInfoCollectUtil.getFusionCubeLicenseInfo(
        EntityUtils.toOldDev(context.get("dev")), 'cat /opt/huawei/fce/apps/platform/data/license/license.xml')
    if not file_res:
        logger.warn('json_res or file_res is empty')
        return FAIL, resource.getString('collect.fail.msg')
    # 系统信息
    sys_info_dict = query_sys_info(context, file_res)
    result_dict.get("System").append(sys_info_dict)

    esn = sys_info_dict.get("ESN")
    FusionCubeDeviceInfoCollectUtil.buildClusterNodeXml(EntityUtils.toOldDev(context.get("dev")),
                                                        context.get("currentDevResultDir"), context.get("siteName"),
                                                        esn)

    # license信息
    result_dict.get("License").append(query_license_info(file_res))
    context['titleListMap'] = TITLE_DICT
    context['retDataMap'] = result_dict
    return SUCCESS, resource.getString('collect.success.msg')


def query_sys_info(context, file_res):
    if 'No such file or directory' in file_res:
        esn = 'NA'
        product_model = 'NA'
    else:
        esn = re.search('<ESN>(.*?)</ESN>', file_res).group(1)
        product_model = re.search('<OfferingProduct name="(.*?)" version="8">', file_res).group(1)
    dev_node = EntityUtils.toOldDev(context.get("dev"))
    return {
        "ESN": esn,
        "Product Version": dev_node.getProductVersion(),
        "Product Model": product_model,
        "System Name": dev_node.getDeviceName(),
        "NE_ID": esn
    }


def get_device_id(device):
    for feature in device.get('extFeatures'):
        if feature.get('extKey') == 'serialNumber':
            return feature.get('extValue')
    return ''


def query_device_list(json_res):
    res = json_res
    devices = res.get("data").get("dataList")
    result = list()
    for device in devices:
        single_device = {
            "Device Type": 'DeviceHost',
            "HW Id": get_device_id(device),
            "VendorName": device.get('deviceMeta').get('vendor'),
            "SN": get_device_id(device),
            "ServerType": device.get('deviceModel')
        }
        result.append(single_device)
    return result


def query_license_info(file_res):
    if 'No such file or directory' in file_res:
        license_sn = 'NA'
        license_esn = 'NA'
        license_model = 'NA'
    else:
        license_sn = re.search('<LSN>(.*?)</LSN>', file_res).group(1)
        license_esn = re.search('<ESN>(.*?)</ESN>', file_res).group(1)
        license_model = re.search('<LicType>(.*?)</LicType>', file_res).group(1)
    return {
        "License SN": license_sn,
        "LICENSE ESN": license_esn,
        "LICENSE SERVICE AUTH TYPE": license_model,
        "SoftwareId": 'NA'
    }
