# -*- coding:utf-8 -*-
import re
import os
from common import commonFunction
from common.commonFunction import getResource
from common.constant import SCRIPT_RET_CODE
from common.constant import StandItemCmd
from common.cliCmdManager  import execCmd
from common import utils
from common import cliCmdManager
from common.cBase import cFastTypeDict

globalRackInfoDict = {}
globalTypeInfoDict = {}
stdItemTitleList =  ["System","Node",'Disk', 'PowerModule', 'Fan']

def execute(context):
    '''
    @summary: collect standard items
    @date: 2014-07-25
    @param context: context object
    @return: (result code, error message) as (integer, string)
    '''
    logger = context.get('logger')
    logger.info('Collect standard item start!')
    sshConnector = context['sshConnector']
	
    dev = context.get("dev")
    userName = dev.getLoginUser().getUserName()
    userPasswd = dev.getLoginUser().getPassword()
    
    systemFieldList = ['Cluster_Version', 'Cluster_ID', 'Cluster_Name', 'Cluster_Version', 'Version']
    NodeList = ['ID', 'Frame Number', 'Function Type', 'Device SN']
    subnetFieldList = ['ID', 'Name', 'MaskAndPrefix', 'Gateway', 'DNS_IP', 'Description']
    nodepoolFieldList = ['ID', 'Name', 'Parent Type', 'Tier ID', 'SPILL Over to Nodepool', 'HDD Total Capacity', 'HDD Used Capacity', 'SSD Total Capacity', 'SSD Used Capacity', 'CAPThrehold(%)', 'Readonly Threhold(%)', 'Recover Value(%)', 'Readonly Value(%)']
    tierFieldList = ['ID', 'Name']
    ncpstatusFieldList = ['ncq_status', 'ncq_status_value']
    smallfileFieldList = ['smallfile']
    
    enclosureFieldList = ['Logic Type', 'SN', 'ID']
    controllerFieldList = ['BoardType', 'BarCode', 'Item', 'Description', 'Manufactured', 'VendorName', 'Location', 'Logic Version', 'PCB Version']
    expansionModuleFieldList = ['BoardType', 'BarCode', 'Item', 'Description', 'Manufactured', 'VendorName', 'ID', 'Logic Version', 'PCB Version']
    intfModuleFieldList = ['BoardType', 'BarCode', 'Item', 'Description', 'Manufactured', 'VendorName', 'ID', 'Logic Version', 'PCB Version']
    powerModuleFieldList = ['Power_type', 'Serial Number', 'Model', 'ProduceDate', 'Vendor', 'ID', 'Version']
    bbuFieldList = ['BoardType', 'BarCode', 'Item', 'Description', 'Manufactured', 'VendorName', 'ID', 'Firmware Version']
    diskFieldList = ['type', 'serialNumber', 'ssd_abrasion', 'model', 'vendor', 'ID', 'firmwareVersion', 'nodeID', 'location']
    fanFieldList = ['parentType', 'Elabel', 'Elabel', 'Elabel', 'Elabel', 'ID']
    softwareFieldList = ['SN', 'SoftwareCurrentVersion', 'Type', 'HotPatchCurrentVersion']
    licenseList = ['License SN', 'LICENSE ESN', 'LICENSE SERVICE AUTH TYPE']
    
    
    
    stdItemTitleMap = {"System":systemFieldList,
                       "Node":NodeList,
                       "Subnet":subnetFieldList,
                       "Nodepool":nodepoolFieldList,
                       "Tier":tierFieldList,
                       "Ncpstatus":ncpstatusFieldList,
                       'PowerModule':powerModuleFieldList,
                       'Disk':diskFieldList,
                       'Fan':fanFieldList,
                       }
    
    stdItemDataMap = {"System":[],
                      "Node":[],
                      "Subnet":[],
                      "Nodepool":[],
                      "Tier":[],
                      "Ncpstatus":[],
                       'PowerModule':[],
                       'Disk':[],
                       'Fan':[],
                       }
    
    devNode = context.get('devNode')
    if not devNode:
        logger.error('Invalid device node object!')
        return (SCRIPT_RET_CODE.FAIL, resource.getString('err.init.dev.failed'))
    else:
        devModel = devNode.getDeviceProductModel(context)
        
    logger.info("context.get('stdItemDict')=" + str(context.get('stdItemDict')))
    for collectItem in stdItemTitleList:
        cmdList = context['stdItemDict'][collectItem]
        logger.info('collectItem=' + str(collectItem))
        logger.info('cmdList=' + str(cmdList))

        if 'Software' == collectItem:
            logger.info('[collectStandard] collect Software...')
            cmd = 'show upgrade package'
            retDictList = collectSoftware(sshConnector, cmd, logger, userName, userPasswd)
            stdItemDataMap[collectItem].extend(retDictList)
            continue
        elif 'License' == collectItem:
            logger.info('[collectStandard] collect License...')
            cmdLst = ['show license', 'show license_active']
            retDictList = collectLicense(sshConnector, cmdLst, logger, userName, userPasswd)
            stdItemDataMap[collectItem].extend(retDictList)
            continue
        for cliCmd in cmdList:
            index1 = cliCmd.find("show system general")
            index2 = cliCmd.find("show system nodepool")
            if index1 >= 0 or index2 >= 0:    
                isSucc, cmdRet = cliCmdManager.execCmd(sshConnector, cliCmd, logger, userName, userPasswd)
                if not isSucc:
                    logger.error('[collectStandard] Execute command [' + cliCmd + '] failed!')
                    logger.error('Maybe the network is abnormal, stop collecting this item:' + str(collectItem))
                    break
                elif not utils.checkCliInfoValid(cmdRet):
                    logger.warn('[collectStandard] Command execute result is invalid!')
                    continue
                else:
                    childList = cmdRet.splitlines();
                    formatFunction = cFastTypeDict(cmdRet, defaultSep=":")
                    dataInfoDictList = formatFunction.handle()[1]
                    adjustItemLocInfo(collectItem, dataInfoDictList, context, devModel)
                    stdItemDataMap[collectItem].extend(dataInfoDictList)
            else:
                isSucc, cmdRet = cliCmdManager.execShellCmd(sshConnector, cliCmd, logger, userName, userPasswd)
                if not isSucc:
                    logger.error('[collectStandard] Execute command [' + cliCmd + '] failed!')
                    logger.error('Maybe the network is abnormal, stop collecting this item:' + str(collectItem))
                    break
                else:
                    deviceLines = cmdRet.splitlines()
                    length = len(deviceLines)
                    deviceStr=""
                    for i in range(2,length):
                        tempStr = deviceLines[i]
                        if(tempStr.find("----------")<0):
                            deviceStr = deviceStr + tempStr
                            deviceStr = deviceStr + "\n"
                        if(tempStr.find("----------")>=0):
                            formatFunction = cFastTypeDict(deviceStr, defaultSep=":")
                            dataInfoDictList = formatFunction.handle()[1]
                            adjustItemLocInfo(collectItem, dataInfoDictList, context, devModel)
                            stdItemDataMap[collectItem].extend(dataInfoDictList)
                            deviceStr=""
                        
    context['titleListMap'] = stdItemTitleMap
    context['retDataMap'] = stdItemDataMap
    collectResult, errMsg = judgeCollectResult(context, stdItemDataMap)
    return (collectResult, errMsg)

def adjustItemLocInfo(collectItem, dataInfoDictList, context, devModel):
    '''
    @summary: adjust item location info
    @date: 2014-08-08
    @param collectItem: collect item
    @param dataInfoDictList: the list of data dictionary
    @param context: context object
    @param devModel: device model
    @return: 
    '''
    global rackInfoDict
    
    logger = context.get('logger')
        
    ctrlOrBBUSlotPosMap = { 'S2600T':'slotpos=1',#1表示后插板,0表示前插板
                    'S5500T':'slotpos=1',
                    'S5600T':'slotpos=0',
                    'S5800T':'slotpos=0',
                    'S6800T':'slotpos=0',
                    'HVS85T':'slotpos=0',
                    'HVS88T':'slotpos=0',
                    '18800F':'slotpos=0',
                    '18500':'slotpos=0',
                    '18800':'slotpos=0'}
    
    for dataInfoDict in dataInfoDictList:
        for val in dataInfoDict.values():
            if val:#IBMS系统不允许所有字段值为空,其中一次自验发现报告中一块硬盘只有“name”字段.
                break
        else:
            logger.error('This information dictionary is invalid:' + str(dataInfoDict))
            dataInfoDictList.remove(dataInfoDict)
                
    for dataInfoDict in dataInfoDictList:
        for key in dataInfoDict:
            if not dataInfoDict[key]:#IBMS系统不允许字段值为空
                logger.warn('Invalid item value for item:' + str(collectItem) + ',key:' + str(key))
                dataInfoDict[key] = '--'
                    
    if collectItem in ['Controller', 'BBU']:#控制器、BBU位置相同（都在前插板或者后插板）
        logger.info('Adjusting item location:' + collectItem)
        for dataInfoDict in dataInfoDictList:
            ctrlOrBBULoc = dataInfoDict.get('Location', '')
            updateKey = 'Location'
            if not ctrlOrBBULoc:
                ctrlOrBBULoc = dataInfoDict.get('ID', '')
                updateKey = 'ID'
                
            if not ctrlOrBBULoc:
                logger.warn('Empty ID or location:' + str(collectItem))
                pass
            else:
                slot = ctrlOrBBULoc
                shelf = ctrlOrBBULoc.split('.')[0]
                rackLocStr = globalRackInfoDict.get(shelf, 'rack=-1')
                slotPos = ctrlOrBBUSlotPosMap.get(devModel, 'slotpos=0')
                dataInfoDict[updateKey] = rackLocStr + ',shelf=' + shelf + ',subshelf=-1,' + slotPos + ',slot=' + slot
    elif collectItem in ['Node']:
        logger.info('Adjusting node location:' + collectItem)
        for dataInfoDict in dataInfoDictList:
            NodeID = dataInfoDict.get('ID', '')
            if not NodeID:
                pass
            else:
               NodeRack = dataInfoDict.get('Frame Number', '') 
               NodeType = dataInfoDict.get('Function Type', '') 
               globalRackInfoDict[NodeID] = 'rack=' + NodeRack
               globalTypeInfoDict[NodeID] = NodeType
               shelfLocStr = 'shelf=' + NodeID
               dataInfoDict['ID'] = 'rack='+ NodeRack + ',' + shelfLocStr
    elif collectItem in ['Enclosure']:
        logger.info('Adjusting item location:' + collectItem)
        for dataInfoDict in dataInfoDictList:
            enclosureID = dataInfoDict.get('ID', '')
            location = dataInfoDict.get('Location', '')
            if not enclosureID or not location:
                pass
            else:
                slot = enclosureID
                shelf = enclosureID.split('.')[0]
                if location == '--':
                    globalRackInfoDict[enclosureID] = 'rack=-1'
                else:
                    globalRackInfoDict[enclosureID] = 'rack=' + location
               
                rackLocStr =  globalRackInfoDict[enclosureID]
                shelfLocStr = 'shelf=' + shelf
                dataInfoDict['ID'] = rackLocStr + ',' + shelfLocStr
    elif collectItem in ['Disk']:#框、盘在前插板
        logger.info('Adjusting item location:' + collectItem)
        for dataInfoDict in dataInfoDictList:
            diskID = dataInfoDict.get('ID', '')
            if not diskID:
                pass
            else:
                slot = dataInfoDict.get('location', '')
                NodeID = dataInfoDict.get('nodeID', '')
                NodeType = globalTypeInfoDict.get(NodeID, '')
                rackLocStr = globalRackInfoDict.get(NodeID, 'rack=-1')
                slotpos = 0 #默认都是前插
                index = slot.find("systemdisk") #系统盘都是后插
                if index >= 0:
                    slotpos = 1
                else:
                    if 'C Node' == NodeType:
                        if int(slot) > 23: #C节点前24块盘都是前插，后12块盘都是后插
                            slotpos = 1
                dataInfoDict['ID'] = rackLocStr + ',shelf=' + NodeID + ',subshelf=-1,slotpos=' + str(slotpos) +',slot=' + '%s' %str(slot)
    elif collectItem in ['ExpansionModule', 'InterfaceModule']:#部件在后插板
        logger.info('Adjusting item location:' + collectItem)
        for dataInfoDict in dataInfoDictList:
            componetID = dataInfoDict.get('ID', '')
            if not componetID:
                pass
            else:
                slot = componetID
                shelf = componetID.split('.')[0]
                rackLocStr = globalRackInfoDict.get(shelf, 'rack=-1')
                dataInfoDict['ID'] = rackLocStr + ',shelf=' + shelf + ',subshelf=-1,slotpos=1,slot=' + slot
    elif collectItem in ['Fan', 'PowerModule']:#部件在后插板
        logger.info('Adjusting item location:' + collectItem)
        for dataInfoDict in dataInfoDictList:
            componetID = dataInfoDict.get('ID', '')
            if not componetID:
                pass
            else:
                slot = componetID
                NodeID = componetID.split('.')[0]
                if 'DSW' in componetID:#只有交换机风扇在前插板
                    slotPos = 'slotpos=0'
                else:
                    slotPos = 'slotpos=1'
                rackLocStr = globalRackInfoDict.get(NodeID, 'rack=-1')    
                dataInfoDict['ID'] = rackLocStr + ',shelf=' + NodeID + ',subshelf=-1,' + slotPos + ',slot=' + slot
    elif  collectItem in ['System']:#部件在后插板           
        logger.info('Adjusting item location:' + collectItem)
        Cluster_Version=dataInfoDict.get('Cluster_Version', '')
        dataInfoDict['Cluster_Version']=Cluster_Version[0:Cluster_Version.find('V')-1]
        dataInfoDict['Version']=Cluster_Version[Cluster_Version.find('V'):]
    else:
        logger.info('No need to adjusting item location:' + collectItem)
        pass    
    
def collectLicense(sshConnector, cmdLst, logger, userName, userPasswd):
    '''
    @summary: collect license
    @date: 2014-08-08
    @param sshConnector: the connector of SSH
    @param cmdLst: command list
    @param logger: a logger provided by tool
    @return: the dictionary list of result
    '''
    
    retDictList = []
    cmdName1 = cmdLst[0]#'show license'
    cmdName2 = cmdLst[1]#'show license_active'
    isSucc, cmdRet = cliCmdManager.execCmd(sshConnector, cmdName1, logger, userName, userPasswd)
    if not isSucc:
        logger.error('[collectStandard] Execute command [' + cmdName1 + '] failed!')
        return []
    if not utils.checkCliInfoValid(cmdRet):
        logger.warn('[collectStandard] Command execute result is invalid!')
        return []
    cliRetLine = cmdRet.splitlines()
    tempMap = {}
    for line in cliRetLine:
        if re.search('License SN', line, re.IGNORECASE):
            tempMap['License SN'] = line.split(':')[1].strip()
            break
    isSucc, cmdRet = cliCmdManager.execCmd(sshConnector, cmdName2, logger, userName, userPasswd)
    if not isSucc:
        logger.error('[collectStandard] Execute command [' + cmdName2 + '] failed!')
        return []
    if not utils.checkCliInfoValid(cmdRet):
        logger.warn('[collectStandard] Command execute result is invalid!')
        return []
    formattedDictList = utils.formatStr(cmdRet)
    formattedDict = formattedDictList[0]
    formattedDict.update(tempMap)
    retDictList.append(formattedDict)
    logger.info('formattedDict=' + str(formattedDict))
    return retDictList


def collectSoftware(sshConnector, cmd, logger, userName, userPasswd):
    '''
    @summary: collect software
    @date: 2014-08-08
    @param sshConnector: the connector of SSH
    @param cmd: command
    @param logger: a logger provided by tool
    @return: the dictionary list of result
    '''
    retDictList = []
    isSucc, cmdRet = cliCmdManager.execCmd(sshConnector, cmd, logger, userName, userPasswd)
    if not isSucc:
        logger.error('[collectStandard] Execute command [' + cmd + '] failed!')
        return []
    if not utils.checkCliInfoValid(cmdRet):
        logger.warn('[collectStandard] Command execute result is invalid!')
        return []
    cmdRetList = cmdRet.splitlines()
    softwareStr = ''
    hotPatchStr = ''
    isSoftware = False
    isHotPatch = False
    for line in cmdRetList:
        if re.search('Software Version', line, re.IGNORECASE):
            isSoftware = True
            isHotPatch = False
        elif re.search('HotPatch Version', line, re.IGNORECASE):
            isSoftware = False
            isHotPatch = True
        elif re.search(':/>', line, re.IGNORECASE):
            isSoftware = False
            isHotPatch = False
        if isSoftware:
            softwareStr += line + os.linesep
        elif isHotPatch:
            hotPatchStr += line + os.linesep
    softwareDictList = utils.formatHDict2List(softwareStr)
    hotPatchDictList = utils.formatHDict2List(hotPatchStr)
    for softwareDict in softwareDictList:
        swVerName = softwareDict.get('Name')
        swVerSn = softwareDict.get('SN')
        swVerCurVer = softwareDict.get('Current Version')
        swVerTpe = softwareDict.get('Type')
        for hotPatchDict in hotPatchDictList:
            hpVerName = hotPatchDict.get('Name')
            if hpVerName == swVerName:
                hpVerCurVer = hotPatchDict.get('Current Version')
                tmpDict = {}
                tmpDict['SN'] = swVerSn
                tmpDict['SoftwareCurrentVersion'] = swVerCurVer
                tmpDict['Type'] = swVerTpe
                tmpDict['HotPatchCurrentVersion'] = hpVerCurVer
                retDictList.append(tmpDict)
    logger.info('retDictList=' + str(retDictList))
    
    newRetDictList = []
    for retDict in retDictList:
        SoftwareCurrentVersion = retDict.get('SoftwareCurrentVersion')
        if '--' != SoftwareCurrentVersion:
            newRetDictList.append(retDict)
            break
    if not newRetDictList:
        newRetDictList = [retDictList[0]]
    return newRetDictList

def judgeCollectResult(context, stdItemDataMap):
    '''
    @summary: Judge collect result.
    @date: 2014-08-12
    @param context: context object
    @param stdItemDataMap: the data map of standard item 
    @return: (return code, error message) as (integer, string)
    '''
        
    errMsgList = []
    logger = context.get('logger')
    resource = getResource(context)    
    collectResutList = []
    
    #1.system
    if not stdItemDataMap['System']:
        logger.error('Collect system information failed!')
        errMsgList.append(resource.getString('err.collect.System.info.fail'))
        collectResutList.append(SCRIPT_RET_CODE.FAIL)
    else:
        errMsgList.append(resource.getString('info.collect.System.info.success'))
        collectResutList.append(SCRIPT_RET_CODE.SUCCESS)
        logger.info('Collect system information success.')

    #6.power module
    powerNum = context.get('PowerModuleNum', 0)
    errMsgList.append(resource.getString('info.collect.PowerModule.info.success'))
    logger.info('%s%d'%('PowerModuleNum',powerNum))
    logger.info('Collect all power information')
    collectResutList.append(SCRIPT_RET_CODE.SUCCESS)
    logger.info('%s%s'%('stdItemDataMap[PowerModule]',str(stdItemDataMap['PowerModule'])))
    
    #8.DISK 
    diskNum = context.get('DiskNum', 0)   
    errMsgList.append(resource.getString('info.collect.Disk.info.success'))
    collectResutList.append(SCRIPT_RET_CODE.SUCCESS)

    #9.FAN
    fanNum = context.get('FanNum', 0)
    errMsgList.append(resource.getString('info.collect.Fan.info.success'))
    collectResutList.append(SCRIPT_RET_CODE.SUCCESS)
    
    NodeNum = context.get('Node', 0)
    errMsgList.append(resource.getString('info.collect.Node.info.success'))
    collectResutList.append(SCRIPT_RET_CODE.SUCCESS)

    if collectResutList.count(SCRIPT_RET_CODE.SUCCESS) == len(stdItemTitleList):
        logger.info('Collect all standard item information success.')
        return SCRIPT_RET_CODE.SUCCESS, ''
    elif collectResutList.count(SCRIPT_RET_CODE.FAIL) == len(stdItemDataMap):
        logger.error('Collect all standard item information failed!')
        return SCRIPT_RET_CODE.FAIL, '\n'.join(errMsgList)
    else:
        logger.warn('Collect part standard item information success.')
        return SCRIPT_RET_CODE.PART_SUCCESS, '\n'.join(errMsgList)
