# -*-:coding: UTF-8 -*-
import re
import cliCmdManager
from constant import CLI_CMD_Prompt
from constant import TV2R2_CLI_CMD


def exitSshConnection(sshConnector, logger):
    '''
    Function describe:    Close current SSH connection.
    Return value:         None.                            

    Revision History:     1. Created 2014-02-22 
    '''        
    
    ssh = sshConnector.getConnectionNoException()
    if not ssh:
        logger.error('Get SSH connection failed when closing CLI connection.')
        return 
    
    while True:        
        try:
            ssh.close()
        except :
            logger.warn('Close SSH connection exception, connection maybe closed!')
            return
        else:
            logger.info('Close SSH connection successfully!')
            return
        

def changeDeveloper2Minisystem(sshConnector, logger):
    '''
    Function describe:    Switch developer mode to minisystem mode.
    Return value:         boolean--Return True if success, 
                                   otherwise return False.                            

    Revision History:     1. Created 2014-02-22 
    '''        
  
    ssh = sshConnector.getConnectionNoException()
    if not ssh:
        logger.error('Get SSH connection failed when switching developer mode to minisystem mode.')
        return False
    
    #进入minisystem
    temp = ssh.execCmdNoLogTimout("minisystem", 5)

    if re.search("minisystem>", temp, re.IGNORECASE):
        return True
    
    if re.search("Are you sure", temp, re.IGNORECASE):
        temp1 = ssh.execCmd("y")

        if re.search("minisystem>", temp1, re.IGNORECASE):
            return True
    
    exitSshConnection(sshConnector, logger)
    return False

        
def changeSafeModel2Minisystem(sshConnector, logger):
    '''
    Function describe:    Switch safe mode to minisystem mode.
    Return value:         boolean--Return True if success, 
                                   otherwise return False.                            

    Revision History:     1. Created 2014-02-22 
    '''        
    ssh = sshConnector.getConnectionNoException()
    if not ssh:
        logger.error('Get SSH connection failed when switching developer mode to minisystem mode.')
        return False
    
    #直接输入minisystem命令
    temp = ssh.execCmd("minisystem")
    if re.search("minisystem>", temp, re.IGNORECASE):
        return True
    else:
        exitSshConnection(sshConnector, logger)
        return False

   

