﻿# -*- coding: UTF-8 -*-
from constant import CmdConstants
from time import sleep
from com.huawei.ism.exception import IsmException
from com.huawei.ism.tool.framework.platform.exception import ToolException


def invoke(tlvConnector, command, params, timeout, logger):
    '''
    Function describe:    Execute TLV command interface.
    Return value:         (boolean, cliRet)    

    Revision History:     1. Created 2014-02-21 
    '''
    
    if not tlvConnector or not command or not logger:
        logger.error('Parameter invalid when execute TLV command[' + str(command) + ']!')
        return (False, '')
    
    #Get(create or reconnect) connection when execute command.    
    tlv = tlvConnector.getConnectionNoException()
    
    tlvRec = None
    exceptionTimes = 0
    isExceptionCaught = False
    
    while exceptionTimes < CmdConstants.TLV_INVOKE_RETRY_TIMES: 
        try:
            tlvRec = tlv.invoke(command, params, timeout)
        except BaseException, e:
            logger.error('[tlvCmdManager.py]-execute TLV command[' + str(command) + '] exception:' + str(e))
            isExceptionCaught = True
        except IsmException, e:
            isExceptionCaught = True
            logger.error('[tlvCmdManager.py]-execute TLV command[' + str(command) + '] caught IsmException:' + str(e))
        except:
            isExceptionCaught = True
            logger.error('Try to get TLV connection again when occurring other Exception!')
        else:
            logger.info('Execute TLV command[' + str(command) + '] successfully, return now!')
            return (True, tlvRec)
        finally:
            if isExceptionCaught:
                sleep(CmdConstants.TLV_RETRY_INTERVAL_TIME)
                exceptionTimes += 1
                logger.warn('Try to get TLV connection again when caught Exception!')
                tlv = tlvConnector.getConnectionNoException()
    else:
        logger.error('Execute TLV command[' + str(command) + '] exception ' + str(CmdConstants.TLV_INVOKE_RETRY_TIMES) + ' times!')
        return (False, tlvRec)


def getBatch(tlvConnector, command, params, timeout, logger):
    '''
    Function describe:    Execute TLV command getBatch interface.
    Return value:         (boolean, tlvRecs)    

    Revision History:     1. Created 2014-02-21 
    '''
    
    if not tlvConnector or not command or not logger:
        logger.error('Parameter invalid when execute TLV getBatch command[' + str(command) + ']!')
        return (False, None)
        
    tlv = tlvConnector.getConnectionNoException()
    
    tlvRecs = None
    exceptionTimes = 0
    
    while exceptionTimes < CmdConstants.TLV_INVOKE_RETRY_TIMES: 
        try:
            tlvRecs = tlv.bacthNext(command, params, timeout)
        except IsmException, e:
            logger.error('[tlvCmdManager.py]-execute TLV command[' + str(command) + '] exception:' + str(e))
            sleep(CmdConstants.TLV_RETRY_INTERVAL_TIME)
            exceptionTimes += 1
            tlv = tlvConnector.getConnectionNoException()
        except:
            logger.error('[tlvCmdManager.py]-execute TLV command[' + str(command) + '] other exception!' )
            sleep(CmdConstants.TLV_RETRY_INTERVAL_TIME)
            exceptionTimes += 1
        else:
            logger.info('Execute TLV command[' + str(command) + '] successfully, return now!')
            return (True, tlvRecs)
    else:
        logger.error('Execute TLV command[' + str(command) + '] exception ' + str(CmdConstants.TLV_INVOKE_RETRY_TIMES) + ' times!')
        return (False, tlvRecs)  
    