﻿# -*- coding:utf-8 -*-
import os

class Resource():
    def __init__(self, context):
        self.lang = context.get('lang')
        self.logger = context.get('logger')
        secondDevPkgDir = context.get('path')
        
        self.logger.info('secondDevPkgDir:' + secondDevPkgDir)
        
        resourceDir = secondDevPkgDir + os.sep + 'res' + os.sep + 'language' + os.sep
        if self.lang == 'en':
            self.resource= resourceDir + 'resource_en.ini'
        else:
            self.resource = resourceDir + 'resource_zh.ini'
        
        self.dict = {}
        self.genDict()
            
    def genDict(self):
        try:
            for line in open(self.resource):
                if line.startswith('[') or line.startswith('#') or '=' not in line:
                    continue
                else:
                    key = line.split('=')[0].strip()
                    val = line.split('=')[1].strip().decode('utf-8','ignore') 
                    self.dict[key] = val
        except BaseException, e:
            self.logger.error('Exception caught when parse resource file:' + str(e))
        else:
            self.logger.info('Generated dictionary successfully')
            
    def getString(self, key):
        return self.dict.get(key, '')
                