# -*- coding:utf-8 -*-
from defusedxml import ElementTree as ET
import os
from common.devNode import DevNode
from common import commonFunction
from common.commonFunction import getResource
from common.constant import SCRIPT_RET_CODE
from common import cliCmdManager
from common.cTV2R2 import cHandleTypeList
from common import utils

def execute(context):
    '''
    @summary: Initialize device node.
    @date: 2015-11-23
    @param context: context object
    @return: 
    '''
    logger = context.get('logger')
    logger.info('[prepare] start to prepare handle...')
    resource = getResource(context)
    devNode = context.get('devNode')
    
    if not devNode:
        devNode = DevNode(context)
        context['sshConnector'] = devNode.getSshConnector(context)
        context['devNode'] = devNode
        logger.info(str(devNode))
        
        if not isSshConnectionNormal(context):
            errMsg = resource.getString('err.create.SSH.connection.failed')
            return (SCRIPT_RET_CODE.FAIL, errMsg)
    errCode, errMsg = parseStdCfgFile(context)
    logger.info('[prepare] finish to prepare handle!')
    return (errCode, errMsg)

def isSshConnectionNormal(context):
    '''
    @summary: Check if the SSH connection is normal
    @date: 2015-11-23
    @param context: context object
    @return: 
    '''
    logger = context.get('logger')
    sshConnector = context['sshConnector']
    if not sshConnector.getConnectionNoException():
        logger.error('Get SSH connection failed!')
        return False
    else:
        logger.info('Get SSH connection successfully!')
        return True
    
def parseStdCfgFile(context):
    '''
    @summary: load and parse configure file, then load to memory
    @date: 2015-11-24
    @param context: context object
    @param xmlFile: the absolute path of configure file
    @param contextKey: the key of context map object
    @return: 
    '''
    logger = context.get('logger')
    resource = getResource(context)
    
    cfgFile4Standard = context.get('path') + os.sep + 'script' + os.sep + 'config' + os.sep + 'cmd4IBMS.xml'
    root = ET.parse(cfgFile4Standard)
    itemList = root.findall('item')
    itemCmdListDict = {}
    errMsg = ''
    errCode = SCRIPT_RET_CODE.SUCCESS
    
    try:
        for item in itemList:
            itemName = item.attrib['name']
            itemCmdList = []
            baseCmd = item.findall('cmd')[0].attrib['command']
            itemCmdList.append(baseCmd)
            itemCmdListDict[itemName] = itemCmdList
    except:
        logger.error('Parse IBMS configure file caught exception.')
        errMsg = resource.getString('err.parse.IBMS.cfg.failed')
        errCode = SCRIPT_RET_CODE.FAIL
    else:
        logger.info('Standard item name-cmdList:' + str(itemCmdListDict))
        context['stdItemDict'] = itemCmdListDict
        errCode = SCRIPT_RET_CODE.SUCCESS
    finally:
        return (errCode, errMsg)
