# coding=UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import traceback

from common.result import set_result_fail
from frame.cli.cliUtil import get_product_model_version
from frame.context.contextUtil import get_item, init_cli_connection, getCli, get_lang
from funcFactory.dataCollectUtil import collect_data
from utils.common_function_util import get_title_from_xm_info
from utils.log_util import Log


def execute(context):
    try:
        # 构造收集项的title
        _set_title_data(context)
        # 构造收集项的收集数据
        return _set_ret_data(context)
    except Exception as ex:
        Log.error("Failed to execute collectStandard file, because %s" % str(traceback.format_exc()))
        return set_result_fail(context, "collect.standard.fail.errMsg")


def _set_title_data(context):
    cmd4_ibms = get_item(context, "cmd4IBMS")
    title_list_map = get_title_from_xm_info(cmd4_ibms)
    context["titleListMap"] = title_list_map


def _set_ret_data(context):
    cmd4_ibms = get_item(context, "cmd4IBMS")
    code, ret_data_map, all_err_msg = collect_data(context, cmd4_ibms)
    # 对cli返回的原始数据进行处理
    _result_handle(context, ret_data_map)
    context["retDataMap"] = ret_data_map
    Log.error(code)
    Log.error(all_err_msg)
    Log.error(context)
    return code, all_err_msg


def _result_handle(context, ret_data_map):
    # 获取产品型号
    init_cli_connection(context)
    cli = getCli(context)
    lang = get_lang(context)
    is_success, product_model, err_msg = get_product_model_version(cli, lang)

    for one_data_key in ret_data_map:
        if one_data_key in ["ExpansionModule", "InterfaceModule", "PowerModule"]:
            data_list = ret_data_map[one_data_key]
            # 删除Health Status为No Input的电源信息

            for one_data in data_list:
                version = one_data["ProductVersion"]
                rack = "-1"
                shelf = ID.split('.')[0]
                subshelf = "-1"
                slotpos = "1"
                one_data["ProductVersion"] = "rack=%s,shelf=%s,subshelf=%s,slotpos=%s,slot=%s" % \
                                             (rack, shelf, subshelf, slotpos, version)

        # 从软件信息中获取一条不为空的数据
        deal_software_info(one_data_key, ret_data_map)
    return


def deal_software_info(one_data_key, ret_data_map):
    if one_data_key in ["Software"]:
        data_list = ret_data_map[one_data_key]
        filte_result = None
        if data_list:
            filte_result = data_list[0]
        for one_data in data_list:
            soft_ware_version = one_data["Current Version"]
            if soft_ware_version != "--" and soft_ware_version != "":
                filte_result = one_data
                break
        ret_data_map[one_data_key] = [filte_result]
