# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import os
import traceback

from common.constant import CMD
from common.result import set_result_fail, set_result_succ
from common.xmlParser import parseXMLFile
from frame.cli.cliUtil import get_product_version
from frame.cli.cliUtil import get_vertical_cli_ret
from frame.context.contextUtil import set_item, get_cli, get_lang
from utils.common_function_util import execute_cmd
from utils.log_util import Log


def execute(context):
    """
    @summary: 框架默认入口函数
    """
    try:
        ini_log(context)

        if not can_exec_cli_cmd(context):
            return set_result_fail(context, "systemStatus.abnormal.errMsg")

        # 解析标准收集项的配置文件
        (is_success, cmd4_ibm_sxml_info) = parse_cmd4_ibms_xml_file(context)
        if not is_success:
            return set_result_fail(context, "parse.xml.cmdxml.fail.errMsg")
        else:
            set_item(context, "cmd4IBMS", cmd4_ibm_sxml_info)
        Log.error(context)
    except Exception as ex:
        Log.error("Failed to execute prepare file, because %s" % str(traceback.format_exc()))
        Log.error("Failed to execute prepare file: %s", ex)
        Log.error(context)
        return set_result_fail(context, "prepare.fail.errMsg")

    return set_result_succ()


def ini_log(context):
    Log(context)


def parse_cmd4_ibms_xml_file(context):
    is_success = True
    cmd4_ibm_sxml_info = None
    try:
        cmd4_ibm_sxml_file = os.path.join(context.get("path"), "script", "config", "cmd4IBMS.xml")
        cmd4_ibm_sxml_info = parseXMLFile(cmd4_ibm_sxml_file)
    except Exception as ex:
        is_success = False
        Log.error("Failed to parse xml file, because %s" % str(traceback.format_exc()))
    return is_success, cmd4_ibm_sxml_info


def parse_cmd4_excelxml_file(context):
    cli = get_cli(context)
    lang = get_lang(context)
    is_success, product_version, err_msg = get_product_version(cli, lang, context)
    if not is_success:
        return is_success, err_msg

    is_success = True
    cmd4_excelxml_info = None
    try:
        product_version = product_version[:11]
        cmd4_excelxml_file_name = "cmd4Excel4%s.xml" % product_version
        Log.error("cmd4ExcelxmlFileName is  %s" % str(cmd4_excelxml_file_name))
        cmd4_excelxml_file = os.path.join(context.get("path"), "script", "config", cmd4_excelxml_file_name)
        cmd4_excelxml_info = parseXMLFile(cmd4_excelxml_file)
    except Exception as ex:
        is_success = False
        Log.error("Failed to parse xml file: %s", ex)
        Log.error("because %s" % str(traceback.format_exc()))
    return is_success, cmd4_excelxml_info


def can_exec_cli_cmd(context):
    is_success, cli_ret, err_msg = execute_cmd(context, CMD.SHOW_SYSTEM_GENERAL)
    get_vertical_cli_ret(cli_ret)
    return True
