# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

class CliConnection(object):
    RE_CONNECTION_TIMES = 3
    _instance = None
    _cli = None

    def __new__(cls, *args, **kwargs):
        if cls._instance is None:
            cls._instance = super(CliConnection, cls).__new__(cls, *args, **kwargs)
        return cls._instance

    def __init__(self, connectorFactory, ip, sshPort):
        self.connectorFactory = connectorFactory
        self.ip = ip
        self.sshPort = sshPort

    def create(self, user, pawd):
        reConnectionTimes = 0
        while self._cli is None and reConnectionTimes < CliConnection.RE_CONNECTION_TIMES:
            sshConnector = self.connectorFactory.createSshConnector(self.ip, self.sshPort, user, pawd)
            self._cli = sshConnector.getConnectionNoException()
            reConnectionTimes += 1
        del pawd
        return self._cli

    def close(self):
        if self._cli is not None:
            try:
                self._cli.close()
            except:
                return
            finally:
                self._cli = None
        return

    def getCli(self, user, pawd):
        if self._cli is None:
            self.create(user, pawd)
        del pawd
        return self._cli
