# -*- coding: UTF-8 -*-
from frame.cli.cliFactory import CliConnection
import os

SCRIPT_DEF_CONTEXT = "SCRIPT_DEF_CONTEXT"
RESOURCE_DEF_CONTEXT = "RESOURCE_DEF_CONTEXT"

CLI_CONNECTION = "CLI_CONNECTION"
TLV_CONNECTION = "TLV_CONNECTION"

def getLang(context):
    return context["lang"]

def getScriptDefDict(context):
    if isinstance(context, dict):
        if not context.has_key(SCRIPT_DEF_CONTEXT):
            context.setdefault(SCRIPT_DEF_CONTEXT, {})
    else:
        if not context.containsKey(SCRIPT_DEF_CONTEXT):
            context.put(SCRIPT_DEF_CONTEXT, {})
    return context.get(SCRIPT_DEF_CONTEXT)

def getResourceDict(context, lang):
    scriptDefDict = getScriptDefDict(context)
    if not scriptDefDict.has_key(RESOURCE_DEF_CONTEXT):
        resourceFilePath = getResourecePath(context, lang)
        resourceFile = open(resourceFilePath)
        contents = resourceFile.read().splitlines()
        resourceDict = {}
        for line in contents:
            fields = line.split("=")
            if len(fields) < 2:  
                continue
            
            key = fields[0].strip()
            value = "=".join(fields[1:]).strip().decode('utf-8','ignore')
            resourceDict.setdefault(key, value)
        scriptDefDict.setdefault(RESOURCE_DEF_CONTEXT, resourceDict)
        
    return scriptDefDict.get(RESOURCE_DEF_CONTEXT)

def setItem(context, key, value):
    scriptDefDict = getScriptDefDict(context)
    scriptDefDict.setdefault(key, value)

    if isinstance(context, dict):
        context.setdefault(SCRIPT_DEF_CONTEXT, scriptDefDict)
    else:
        context.put(SCRIPT_DEF_CONTEXT, scriptDefDict)
    return

def removeItem(context, key):
    scriptDefDict = getScriptDefDict(context)
    scriptDefDict.pop(key)
    return

def getItem(context, key):
    scriptDefDict = getScriptDefDict(context)
    return scriptDefDict.get(key, None)

def getConnectorFactoryObj(context):
    return context.get("connectorFactory")

def getDevObj(context):
    return context.get("dev")

def initCliConnection(context):
    connectorFactoryObj = getConnectorFactoryObj(context)
    devObj = getDevObj(context)
    
    ip = devObj.getIp()
    sshPort = int(devObj.getPort())
    
    conn = CliConnection(connectorFactoryObj, ip, sshPort)
    conn.create(devObj.getLoginUser().getUserName(), devObj.getLoginUser().getPassword())
    
    setItem(context, CLI_CONNECTION, conn)
    return

def getCli(context):
    conn = getItem(context, CLI_CONNECTION)
    if conn is None:
        return None
    
    devObj = getDevObj(context)
    cli = conn.getCli(devObj.getLoginUser().getUserName(), devObj.getLoginUser().getPassword())
    return cli

def destroyCliConnection(context):
    conn = getItem(context, CLI_CONNECTION)
    if conn is not None:
        conn.close()
        removeItem(context, CLI_CONNECTION)
    return

def initTlvConnection(context):
    connectorFactoryObj = getConnectorFactoryObj(context)
    devObj = getDevObj(context)
    
    ip = devObj.get("ip")
    tlvPort = devObj.get("tlvPort")
    user = devObj.get("user") 
    
    conn = TlvConnection(connectorFactoryObj, ip, tlvPort, user, devObj.get("pawd"))
    conn.create()
    
    setItem(context, TLV_CONNECTION, conn)
    return

def getTlv(context):
    conn = getItem(context, TLV_CONNECTION)
    if conn is None:
        return None
    
    tlv = conn.getTlv()
    return tlv

def destroyTlvConnection(context):
    conn = getItem(context, TLV_CONNECTION)
    if conn is not None:
        conn.close()
        removeItem(context, TLV_CONNECTION)
    return

def setResult(context, flag, errMsg="", suggestion=""):
    context["succ"] = flag
    context["errMsg"] = errMsg
    context["suggestion"] = suggestion
    return

def handleSuccess(context):
    setResult(context, True)
    return

def handleFailure(context, resultDict):
    flag = resultDict["flag"]
    errMsg = resultDict["errMsg"]
    suggestion = resultDict["suggestion"]
    setResult(context, flag, errMsg, suggestion)
    return

def handleException(context):
    lang = getLang(context)
    errMsg, suggestion = common.getMsg(lang, "query.result.abnormal")
    setResult(context, False, errMsg, suggestion)
    return

def handleIsmException(context):
    lang = getLang(context)
    errMsg, suggestion = common.getMsg(lang, "query.result.abnormal")
    setResult(context, False, errMsg, suggestion)
    return


def getResource(context, lang, key):
    resourceDict = getResourceDict(context, lang)
    return resourceDict.get(key, "--")

def getResourecePath(context, lang):
    return os.path.join(getImportRootDir(context), "script", "res", "language", "resource_%s.ini" % lang)
    
def getImportRootDir(context):
    return context.get("path")

