# -*- coding:utf-8 -*-


def getLang(context):
    '''
    @summary: get language type, e.g. zh, en etc
    '''
    return context.get('language')


def getDev(context):
    '''
    @summary: get device node object
    '''
    return context.get('devNode')


def isAccountAdmin(context):
    '''
    @summary: check user authority, judge whether current account is 'admin'
    @param context: the context object which provided by tool framework
    @return: user authority is 'admin' return true, otherwise return false
    '''
    deviceNode = getDev(context)
    userName = str(deviceNode.getLoginUser().getUserName())
    #若用户名为admin即为超级管理员账户
    if 'admin' == userName.strip():
        return True
    return False


def isDebugPwdExistent(context):
    '''
    @summary: check whether debug password exist
    @param context: the context object which provided by tool framework
    @return: existent return true, otherwise return false
    '''
    deviceNode = getDev(context)
    developerPwd = deviceNode.getDeveloperPwd()
    #判断调试密码是否为空
    if not developerPwd:
        return False
    return True


def execute(context):
    '''
    @summary: the entrance method
    @detail: this method is used to check login information of user, 
    e.g. user authority, whether the debug password exists and so on.
    @param context: the context object which provided by tool framework
    @return: (need tip or not, warn information) as (boolean, string)
    '''
    lang = getLang(context)
    isTipShownKey = 'Flag'  #是否需要界面提示key
    isTipShownVal = 'False' #是否需要界面提示value，默认不需要提示
    errMsgKey = 'infoMsg'   #提示信息key
    errMsgVal = ''          #提示信息value
    
    #检查用户权限是否为超级管理员
    if not isAccountAdmin(context):
        isTipShownVal = 'True'
        if 'zh_CN' == lang:
            errMsgVal += u'当前账户不是超级管理员，请切换至超级管理员账户重新登录，输入调试密码再执行设备档案收集。\
若忽略该警告继续执行将导致收集失败。（S系列设备必须使用超级管理员账户收集设备档案信息）'
        else:
            errMsgVal += 'The current account is not a super administrator account. Switch to the super administrator account, \
log in again, and enter the debug password to collect device archives. If you ignore this alarm and proceed with next steps, \
the archive collection will fail. (You must use the super administrator account to collect device archives of the S series devices.)'
        return {isTipShownKey:isTipShownVal, errMsgKey:errMsgVal}
    
    #检查是否设置调试密码
    if not isDebugPwdExistent(context):
        isTipShownVal = 'True'
        if 'zh_CN' == lang:
            errMsgVal += u'该设备未设置调试密码，请先设置调试密码再收集。若忽略该警告继续执行将导致收集失败。'
        else:
            errMsgVal += 'The device does not have a debug password. Set a debug password and collect archives again. \
If you ignore this alarm and proceed with next steps, the archive collection will fail.'
    return {isTipShownKey:isTipShownVal, errMsgKey:errMsgVal}

