﻿# -*- coding: UTF-8 -*-
from common.exception import DisconnectionException
from time import sleep

from constant import CmdConstants


def execCmd(sshConnector, cmd, logger, isWithLog=True):
    '''
    Function describe:    Execute CLI command interface.
    Return value:         (boolean, cliRet)    

    Revision History:     1. Created 2014-02-21 
    '''

    if not sshConnector or not cmd:
        if logger:
            logger.error('[cliCmdManager]Parameter invalid when execute CLI command!')
        return (False, None)
    if not logger:
        return (False, None)

    ssh = sshConnector.getConnectionNoException()

    cliRet = ''
    exceptionTimes = 0

    while exceptionTimes < CmdConstants.CLI_EXECMD_RETRY_TIMES:
        try:
            if isWithLog:
                cliRet = ssh.execCmdWithTimout(cmd, CmdConstants.CLI_DEFAULT_TIMEOUT)
            else:
                cliRet = ssh.execCmdNoLogTimout(cmd, CmdConstants.CLI_DEFAULT_TIMEOUT)
        except:
            if isWithLog:
                logger.error('execute command {} exception!'.format(cmd))
            else:
                logger.error('execute command exception!')
            sleep(CmdConstants.CLI_RETRY_INTERVAL_TIME)
            exceptionTimes += 1

            logger.warn('Try to get SSH connection again!')
            ssh = sshConnector.getConnectionNoException()
        else:
            if isWithLog:
                logger.info('Execute command {} successfully!'.format(cmd))
            else:
                logger.info('Execute command successfully!')
            logger.info(cliRet)
            return (True, cliRet)
    else:
        if isWithLog:
            logger.error('Execute command {} exception 3 times!'.format(cmd))
        else:
            logger.error('Execute command exception 3 times!')
        # 处理不同阶段网络断开问题（涉及的问题单为： ）Begin
        raise DisconnectionException
        # 处理不同阶段网络断开问题（涉及的问题单为： ）End
