# -*-:coding: UTF-8 -*-
import re
from common.exception import DisconnectionException
import cliCmdManager
from constant import S5000_CLI_CMD

def changeCli2Debug(sshConnector, devPasswd, logger):
    '''
    Function describe:    Switch CLI mode to developer mode.
    Return value:         boolean--Return True if success, otherwise return False.                            

    Revision History:     1. Created 2014-02-22 
    '''
    ret = cliCmdManager.execCmd(sshConnector, S5000_CLI_CMD.SWITCH_TO_DEBUG, logger)
    if not ret[0]:
        logger.error('Switch to debug mode failed!')
        return False
    
    #判断是否已经debug模式
    temp = ret[1]
    if re.search("Password", temp, re.IGNORECASE):
        isSucc, temp = cliCmdManager.execCmd(sshConnector, devPasswd, logger, isWithLog=False)
        if isSucc:
            logger.info("[cliModeManager]: Judge whether enter to the debug mode.")
            # ，非超级用户时判断有误，2015/03/06 modified Begin
            if temp.strip().endswith('#') or (temp.strip().endswith('>') and "@" in temp.splitlines()[-1]):
                return True
            # ，非超级用户时判断有误，2015/03/06 modified End
    
    #进入debug模式失败，重新回到CLI模式
    logger.error('[cliModeManager]: Enter into debug mode failed!')
    exitSshConnection(sshConnector, logger)
    return False

def changeCli2Mml(sshConnector, devPasswd, logger):
    '''
    Function describe:    Switch CLI mode to diagnose mode.
    Return value:         boolean--Return True if success, 
                                   otherwise return False.                            

    Revision History:     1. Created 2014-02-22 
    '''    
    if not changeCli2Debug(sshConnector, devPasswd, logger):
        logger.error('Switch CLI mode to debug mode failed when switching CLI mode to MML mode!')
        return False
    
    isSucc, devRet = cliCmdManager.execCmd(sshConnector, "mml", logger)
    if isSucc:
        logger.info("[cliModeManager]: Judge whether enter to the MML mode.")
        if re.search('>', devRet, re.IGNORECASE):
            return True

    #进入MML模式失败，重新回到CLI模式
    logger.error('[cliModeManager]: Enter into MML mode failed!')
    exitSshConnection(sshConnector, logger)
    return False 

def exitSshConnection(sshConnector, logger):
    '''
    Function describe:    Close current SSH connection.
    Return value:         None.                            

    Revision History:     1. Created 2014-02-22 
    '''        
    
    ssh = sshConnector.getConnectionNoException()
    if not ssh:
        logger.error('Get SSH connection failed when closing CLI connection.')
        return 
    
    while True:        
        try:
            ssh.close()
        except :
            logger.warn('Close SSH connection exception, connection maybe closed!')
            return
        else:
            logger.info('Close SSH connection successfully!')
            return        
