﻿# -*-coding:utf-8 -*-
from com.huawei.ism.tool.framework.platform.exception import ToolException
from com.huawei.ism.tlv.lang import UnsignedInt32
from com.huawei.ism.tlv.bean import Param
from com.huawei.ism.tlv.docoder import ParamType
from com.huawei.ism.tlv.bean import Record
from com.huawei.ism.tlv import TLVUtils

from cliCmdManager import execCmd
from cliModeManager import changeCli2Mml,exitSshConnection
from constant import S5000_CLI_CMD
from constant import TV1_CLI_CMD
from constant import CmdConstants
from cliParser import CliParser
from resource import Resource

import utils
import re

def getResource(context):
    '''
    Function describe: Get resource instance.
    Input:            
    Return value:     (resource)
                        
    Revision History: 1. Created 2014-02-21
    '''
    resource = context.get('resource')
    if not resource:
        resource = Resource(context)
        context['resource'] = resource
    
    return resource

def createSshConnector(context):
    '''
    Function describe: Crate SSH connector.
    Input:            
    Return value:     (SshConnector)
                        
    Revision History: 1. Created 2014-02-21
    '''
    
    sshConnectorFactory = context.get('connectorFactory')
                          
    sshConnector = sshConnectorFactory.createSshForwardConnector(context.get('dev'))
    
    return sshConnector


def isS5000SystemNormal(sshConnector, devPasswd, logger):
    '''
    @summary: Get the system status for TV1 series
    @date: 2014-08-27
    @param logger: the logger which provided by tool
    @return: the status of system
    '''
    if not changeCli2Mml(sshConnector, devPasswd, logger):
        logger.error('Switch to MML mode failed!')
        return  False
    
    isSucc, cmdRet = execCmd(sshConnector, 'sys status', logger)
    if not isSucc:
        logger.error('[commonFunction]Execute MML command [sys status] failed!')
        exitSshConnection(sshConnector, logger)
        return  False
    
    exitSshConnection(sshConnector, logger)
    '''
    Double Or Single : [ double ]
    Master Or Slave : [ slave ]
    Local Controller Status : [ normal ]
    Peer Controller Status : [ normal ]
    System Running Status : [ normal mode ]
    '''
    # 问题单：解决系统单控在位但状态为abnormal时，不能收集软件信息问题Begin
    localCtrlIsNormal = False #本端系统状态
    peerCtrlIsNormal = False #对端系统状态
    systemRunStatus = False #系统运行状态
   
    for line in cmdRet.splitlines():
        if 'local controller status' in line.lower():
            if 'normal' in line.lower() and 'abnormal' not in line.lower():
                localCtrlIsNormal = True
                
        if 'peer controller status' in line.lower():
            if ('normal' in line.lower() and 'abnormal' not in line.lower()) or ('not exist' in line.lower()):
                peerCtrlIsNormal = True                
        if 'system running status' in line.lower():
            if 'normal' in line.lower() and 'abnormal' not in line.lower():
                systemRunStatus = True
                
    #系统运行状态normal前提下，系统双控都normal或者本端normal，对端not exist，这两种才进行档案的收集。
    if localCtrlIsNormal and peerCtrlIsNormal and systemRunStatus:
        return True
    else:
        return False
    # 问题单：解决系统单控在位但状态为abnormal时，不能收集软件信息问题End
   
def getDeviceProductModel(sshConnector, logger):
    '''
    Function describe:    Get the product model of controller by CLI.
    Return value:         tuple(boolean, string)
                                  boolean-true if command executed success, false if command executed failed.
                                  string-device product model, e.g., S5500T.
    Revision History:     1. Created 2014-01-07 
    '''
    productModel = ''
    
    execRet = execCmd(sshConnector, S5000_CLI_CMD.SHOWSYS, logger)
    if not execRet[0]:
        logger.error('Execute command [' + S5000_CLI_CMD.SHOWSYS + '] failed!')
        return productModel
    
    cliEcho = execRet[1]
    
    modelParse = CliParser(cliEcho, logger, cliType='dict')
    sysInfoDic = modelParse.genDict()
    productModel = sysInfoDic.get('Device Model').split()[1].strip()
    logger.info('Got product model:' + str(productModel))
    
    return productModel


     
def formatEletricLabelToDict(electricLbl):
    ''''
    Function describe:    Format electrical label string to a dictionary.
    Return value:         list:Expansion module ID' list.

    Revision History:     1. Created 2014-07-28 
    '''    
    eleLblDict = {}
    for line in electricLbl.splitlines():
        if '=' in line:
            key = line.split('=')[0].strip()
            val = line.split('=')[1].strip()
            eleLblDict[key] = val
    
    return eleLblDict
              

def handleS5000InterfaceCli(cliRet, logger):
    ''''
    Function describe:    Format showinterface echo message to a dictionary.
    Return value:         dictionary.
    Note: for s5000 series product only.
    Revision History:     1. Created 2015-01-16 
    '''
        
    cliRet = cliRet.encode('utf8')
    titleFound = False
    dictList = []
    fieldNames = []
    fieldVals = []
    
    lines = cliRet.splitlines()
    lineNum = len(lines)
    lineIndex = 0
    fieldNum = 0
    
    while lineIndex < lineNum:
        line = lines[lineIndex].strip()
        logger.info('Current line :' + str(line))
        if not line or '>' in line:
            lineIndex += 1
            continue
        
        if len(line.split('  ')) >= 2:#字段行或者值行
            if not titleFound:#字段行
                titleFound = True
                fieldNames = line.split('  ')
                fieldNames = [fieldName.strip() for fieldName in fieldNames]
                fieldNames = [fieldName for fieldName in fieldNames if fieldName]
                fieldNum = len(fieldNames)
                lineIndex += 1
                continue
            else:#值行
                fieldVals = line.split('  ')
                if len(fieldVals) > 1:
                    fieldVals = [ fieldVal.strip() for fieldVal in fieldVals]
                    fieldVals = [ fieldVal for fieldVal in fieldVals if fieldVal][0:fieldNum]
                    dictList.append(dict(zip(fieldNames, fieldVals)))

                    lineIndex += 1
                    continue
        else:#非字段行和有效值行(Elabel)
            while lineIndex < lineNum:
                line = lines[lineIndex].strip()
                if not line:
                    lineIndex += 1
                    continue 
                
                if '=' in line:
                    eblKey =line.split('=')[0].strip()
                    eblVal =line.split('=')[1].strip()
                    dictList[-1][eblKey]= eblVal
                    lineIndex += 1
                    continue                
                else:#非空行，且不包含“=”，跳出循环
                    if len(line.split('  ')) >= 2:
                        break
                    else:
                        lineIndex += 1
                        break
                    
    return dictList
            