﻿# -*- coding:utf-8 -*-
from com.huawei.ism.tlv.lang import UnsignedInt32
from com.huawei.ism.tlv.bean import Param
from com.huawei.ism.tlv.docoder import ParamType
from com.huawei.ism.tlv.bean import Record
from com.huawei.ism.tlv import TLVUtils
from com.huawei.ism.exception import IsmException
from com.huawei.ism.tool.framework.pubservice.exception import ConnectionException
from com.huawei.ism.tool.framework.platform.exception import ToolException

from cliCmdManager import execCmd

from constant import S5000_FactoryCfg,CMD_DEFAULT_TIMEOUT
from constant import RET_CODE,CmdConstants
import commonFunction 

class DevNode():
    def __init__(self, context):
        dev = context.get("dev")
        self.logger = context.get('logger')
        self.deviceName = dev.getDeviceName()
        self.sn = dev.getDeviceSerialNumber()
        self.localIP = dev.getIp()
        self.peerIP = dev.getPeerIp()
        self.sshPort = dev.getPort()
        self.userName = dev.getLoginUser().getUserName()
        self.userPassword = dev.getLoginUser().getPassword()
        self.devPwd = dev.getDeveloperPwd()
        self.lang = context.get('lang')
        
    def __str__(self):
        return ('sn:' + str(self.sn)
                + '\n' + 'localIP:' + str(self.localIP)
                + '\n' + 'peerIP:' + str(self.peerIP)
                + '\n' + 'sshPort:' + str(self.sshPort)
                + '\n' + 'userName:' + str(self.userName)
                + '\n' + 'lang:' + str(self.lang))
                
    def __CreateSshConnector(self, context):
        '''
        Function describe: Crate SSH connector.
        Input:            
        Return value:     (None)
                            
        Revision History: 1. Created 2014-07-28
        '''
        self.sshConnector = commonFunction.createSshConnector(context) 
        return     
    
    def getSshConnector(self, context):
        '''
        Function describe: Crate SSH connector.
        Input:            
        Return value:     (None)
                            
        Revision History: 1. Created 2014-07-28
        '''
        try:
            return self.sshConnector
        except:
            self.__CreateSshConnector(context)
            return self.sshConnector
        else:
            pass
        
    
    def isSystemNormal(self, context):
        '''
        @summary: Judge whether the system is normal for TV1 series
        @date: 2014-08-27
        @param context: the context object
        @return: True or False
        '''
        sshConnector = self.getSshConnector(context)
        return commonFunction.isS5000SystemNormal(sshConnector, self.devPwd, self.logger)
    
    def getDeviceProductModel(self, context):
        '''
        Function describe:    Get the product model of controller by CLI.
        Return value:         tuple(boolean, string)
                                      boolean-true if command executed success, false if command executed failed.
                                      string-device product model, e.g., S5500T.
        Revision History:     1. Created 2014-07-28 
        '''
        logger = self.logger
        sshConnector = self.getSshConnector(context)
      
        return commonFunction.getDeviceProductModel(sshConnector, logger)    
    