# -*- coding:utf-8 -*-
import traceback
import os
import re
from common.log import Log
from common import cliCmdManager
from common import utils
from common.cBase4TV1 import cFastTypeDict
from common import commonFunction
from common.commonFunction import getResource, isSshConnectionNormal
from common.constant import SCRIPT_RET_CODE, CmdRetOrientation
from common.contextUtil import getSshConnector, getExtItemCmdDict, getLogger
from common.exception import DisconnectionException
from common.cTV2R2 import cHandleTypeList


G_cmdExecRetDict = {}
G_IS_CMD_SUCC = 'isCmdSucc'
G_IS_RET_VALID = 'isRetValid'
G_IS_RET_PARSABLE = 'isRetParsable'
G_CMDRET = 'cmdRet'


def execute(context):
    '''
    @summary: the entrance of main method
    @param context: the context object provided by tool framework 
    '''
    Log.updateScriptFlag('collectExtend')
    Log.info('Start to collect extend item...')
    resource = getResource(context)
    try:
        #判断SSH连接是否正常
        if not isSshConnectionNormal(context):
            errMsg = resource.getString('dev.conn.failure')
            return (SCRIPT_RET_CODE.FAIL, errMsg, {})
        
        #1.收集和封装数据
        extTitleListMap, extRetDataMap = collectData(context)
        
        #2.装载数据
        context['titleListMap'] = extTitleListMap
        context['retDataMap'] = extRetDataMap
        
        #3.判断收集结果
        resultCode, errMsg, errMsgDetailDict = judgeCollectResult(context, extRetDataMap)
        return (resultCode, errMsg, errMsgDetailDict)
    except DisconnectionException, de:
        Log.error('Maybe the network is unavailable or device is abnormal, details:' + traceback.format_exc())
        errMsg = resource.getString('dev.conn.failure')
        return (SCRIPT_RET_CODE.FAIL, errMsg, {})
    except:
        Log.error('Failed to collect extend item, details:' + traceback.format_exc())
        errMsg = resource.getString('err.collect.Extend.info.fail')
        return (SCRIPT_RET_CODE.FAIL, errMsg, {})


def getCtrlIpList(cmdRet):
    '''
        控制器管理网口IP地址可能出现换行的情况。
    '''
    ctrlIpDictList = []
                                    
    tempDict = {}
    lines = cmdRet.splitlines()
    if len(lines[6].split()) == 5:
        formatFunction = cHandleTypeList(cmdRet)
        ret = formatFunction.handle()
        if len(ret) >= 2:
            ctrlIpDictList = ret[1]
    else:
        for line in lines[6:]:
            if '===' in line:
                break
            ipInfo = line.split()
            if len(ipInfo) >= 3:
                tempDict['Controller ID'] = ipInfo[0]
                tempDict['IP Address'] = ipInfo[1]
                tempDict['Mask'] = ipInfo[2]
                if len(ipInfo) == 4:
                    tempDict['Gateway'] = ipInfo[3]
            elif len(ipInfo) == 1:
                tempDict['MAC Address'] = ipInfo[0]
                ctrlIpDictList.append(tempDict)
                tempDict = {}
    return ctrlIpDictList
            

def collectData(context):
    '''
    @summary: collect data
    @param context: context object
    @return: (titleListMap, retDataMap) as (dict, dict)
    '''
    titleListMap = {}
    retDataMap = {}
    global G_cmdExecRetDict
    
    #1.获取收集项及命令
    extItemCmdDict = getExtItemCmdDict(context)
    sshConnector = getSshConnector(context)
    resource = getResource(context)
    
    #2.发命令收集并解析回文
    #3.提取并封装数据
    for itemName in extItemCmdDict.keys():
        cmdList = extItemCmdDict.get(itemName)
        dataInfoDictList = []
        titleListMap[itemName] = []
        retDataMap[itemName] = []
        initCmdExecRetDict(itemName)
        if not cmdList:
            Log.warn('The command list of %s is null !' % itemName)
            continue
        
        Log.info('Collecting %s...' % itemName)
        for cliCmd in cmdList:
            isCmdExecSucc, cmdRet = cliCmdManager.execCmd(sshConnector, cliCmd, getLogger(context))
            if not isCmdExecSucc:   #命令未执行成功
                oldCmdRet = G_cmdExecRetDict.get(itemName).get(G_CMDRET)
                errMsg = resource.getString('dev.conn.failure')
                tmpDict = {G_IS_CMD_SUCC:False, G_IS_RET_VALID:False, G_IS_RET_PARSABLE:False, G_CMDRET:oldCmdRet + errMsg}
                G_cmdExecRetDict.get(itemName).update(tmpDict)
                Log.error('Failed to execute command [%s] !' % cliCmd)
                Log.error('Maybe the network is abnormal, stop collecting this item:' + itemName)
                raise DisconnectionException(errMsg)
            isRetValid, isParsable = utils.checkCliInfoValid(cmdRet)    #检查回显是否有效
            if not isRetValid:
                oldCmdRet = G_cmdExecRetDict.get(itemName).get(G_CMDRET)
                tmpDict = {G_IS_RET_VALID:False, G_IS_RET_PARSABLE:False, G_CMDRET:oldCmdRet + cmdRet}
                G_cmdExecRetDict.get(itemName).update(tmpDict)
                Log.error('The result of command [%s] is invalid and not parsable.' % cliCmd)
                continue
            elif not isParsable:
                oldCmdRet = G_cmdExecRetDict.get(itemName).get(G_CMDRET)
                tmpDict = {G_IS_RET_PARSABLE:False, G_CMDRET:oldCmdRet + cmdRet}
                G_cmdExecRetDict.get(itemName).update(tmpDict)
                Log.warn('The result of command [%s] is valid but not parsable.' % cliCmd)
                continue
            if itemName == 'controller IP':
                dataInfoDictList = getCtrlIpList(cmdRet)
            elif itemName in CmdRetOrientation.horizontalLst:
                formatFunction = cHandleTypeList(cmdRet)
                ret = formatFunction.handle()
                if len(ret) < 2:
                    continue
                dataInfoDictList = ret[1]
            else:
                formatFunction = cFastTypeDict(cmdRet, defaultSep="|")
                dataInfoDictList = formatFunction.handle() 
            
            #两次都解析失败，解析接口不支持。。。
            if not dataInfoDictList:
                Log.info('The item [%s] data is None' % itemName)
                
            # 针对主从关系命令的处理Begin[涉及问题单： ]
            masterAndSlaveRelationshipItemnamesList = ['mirror LUN']
            if len(cliCmd.split())>2 and (itemName  in masterAndSlaveRelationshipItemnamesList):
                for datInfo in dataInfoDictList:
                    parentID = 'Master ID'
                    datInfo[parentID] = cliCmd.split()[2]

            groupRelationshipItemnamesList = ['remote replication consistent group member']
            if len(cliCmd.split())>2 and (itemName  in groupRelationshipItemnamesList):
                for datInfo in dataInfoDictList:
                    parentID = 'Group ID'
                    datInfo[parentID] = cliCmd.split()[2]
            # 针对分组关系命令的处理End[涉及问题单： ]
            
            Log.info('dataInfoDictList=' + str(dataInfoDictList))
            retDataMap[itemName].extend(dataInfoDictList)
            
        titleListMap[itemName] = getTitleList(retDataMap[itemName])
    return (titleListMap, retDataMap)


def initCmdExecRetDict(itemName):
    '''
    @summary: initial the global dictionary of command executed result 
    @param itemName: the collect item name
    '''
    G_cmdExecRetDict[itemName] = {G_IS_CMD_SUCC:True, G_IS_RET_VALID:True, G_IS_RET_PARSABLE:True, G_CMDRET:''}


def getTitleList(dataInfoDictList):
    '''
    @summary: get the list of title
    @param dataInfoDictList: data information dictionary list
    @return: the list of title
    '''
    titleList = []
    if not dataInfoDictList:
        return titleList
    titleList = dataInfoDictList[0].keys()
    if len(dataInfoDictList) == 1:
        return titleList
    else:
        for dataInfoDict in dataInfoDictList[1:]:
            for title in dataInfoDict:
                if title not in titleList:
                    titleList.append(title)
        
        return titleList



def judgeCollectResult(context, extRetDataMap):
    '''
    @summary: Judge collect result.
    @param context: context object
    @param extRetDataMap: the data map of standard item 
    @return: (result code, error message) as (integer, string)
    '''
    resource = getResource(context)
    errMsgList = []
    collectResutList = []
    Log.info('G_cmdExecRetDict=%s' % unicode(G_cmdExecRetDict))
    errMsgDetailDict = {}
    
    #判断单项收集结果：成功、失败or部分成功
    for itemName in extRetDataMap:
        collNum = len(extRetDataMap.get(itemName))#单项实际收集到的个数
        Log.info('[%s] collNum=%s' % (itemName, collNum))
        isRetValid = G_cmdExecRetDict.get(itemName).get(G_IS_RET_VALID)
        cmdRet = G_cmdExecRetDict.get(itemName).get(G_CMDRET)
        
        if True == isRetValid:#单项收集全部成功
            Log.info('Collect %s information successful.' % itemName)
            errMsg = resource.getString('info.collect.%s.info.success' % itemName)
            errMsgList.append(errMsg)
            errMsgDetailDict[errMsg] = ''
            collectResutList.append(SCRIPT_RET_CODE.SUCCESS)
        elif False == isRetValid and 0 == collNum:#单项收集全部失败
            Log.info('Collect %s information failed.' % itemName)
            errMsg = resource.getString('err.collect.%s.info.fail' % itemName)
            errMsgList.append(errMsg)
            errMsgDetailDict[errMsg] = cmdRet
            collectResutList.append(SCRIPT_RET_CODE.FAIL)
        else:#单项收集部分成功
            Log.info('Collect part %s information failed.' % itemName)
            errMsg = resource.getString('err.collect.part.%s.info.fail' % itemName)
            errMsgList.append(errMsg)
            errMsgDetailDict[errMsg] = cmdRet
            collectResutList.append(SCRIPT_RET_CODE.PART_SUCCESS)
    
    Log.info('errMsgDetailDict=' + unicode(errMsgDetailDict))
    
    #判断总体收集成功、失败还是部分成功
    if collectResutList.count(SCRIPT_RET_CODE.SUCCESS) == len(extRetDataMap):
        Log.info('Collect all extend item information success.')
        return (SCRIPT_RET_CODE.SUCCESS, '', errMsgDetailDict)
    elif collectResutList.count(SCRIPT_RET_CODE.FAIL) == len(extRetDataMap):
        Log.error('Collect all extend item information failed!')
        return (SCRIPT_RET_CODE.FAIL, os.linesep.join(errMsgList), errMsgDetailDict)
    else:
        Log.warn('Collect part extend item information success.')
        return (SCRIPT_RET_CODE.PART_SUCCESS, os.linesep.join(errMsgList), errMsgDetailDict)
