# -*- coding: UTF-8 -*-
from common.commonFunction import checkUserPrivilege,isExistCmdForRec,downloadFile,getResource,isSshConnectionNormal,getIpList,getCurrentDate
from common.constant import CONFIG,SCRIPT_RET_CODE
import traceback
import socket
from common.log import Log
from common.commonFunction import excuteCmd
from frame.context.contextUtil import initCliConnection
from cbb.frame.util.public_ip_address_utils import get_export_config_used_ip

def execute(context):
    try:
        errMsg = ""
        #初始化CLI
        initCliConnection(context)
        #创建SSH连接
        resource = getResource(context)
        if not isSshConnectionNormal(context):
            errMsg = resource.getString('dev.conn.failure')
            return (SCRIPT_RET_CODE.FAIL, errMsg)
        
        #检查用户级别是否满足收集信息
        isPrivilege ,errMsg = checkUserPrivilege(context)
    
        if not isPrivilege:
            return False , errMsg      
        #执行收集Config.TXT文件的业务流程
        myname = socket.getfqdn(socket.gethostname())
        myaddr = socket.gethostbyname(myname)
        ipAddr = get_export_config_used_ip()
        Log.info("ipAddr is :%s" %(str(ipAddr)) )
        #构造收集下载TXT文件名称，便于之后指定删除
        
        currentsystime = getCurrentDate()
        temfile = "config" + "_" + currentsystime + ".txt"
        
        strCmd = "exportconf -ip %s -u ftp_user -pwd ****** -f %s" % (ipAddr, temfile)
        
        isSuccess,cliRet ,errMeg  = excuteCmd(context,strCmd)
        Log.info("cliRet is: %s" % str(cliRet)) 
        if CONFIG.TV1R5_STRRET in cliRet or CONFIG.TV1R1_STRRET in cliRet:
            pass
        else:
            Log.info("cliRet is : %s" % str(cliRet)) 
            return False ,errMeg 
        
        existCmd = isExistCmdForRec(cliRet)
        if not existCmd:
        #命令不存在，表示环境版本过低，直接收集成功
            Log.info("commend not exist %s" % str(cliRet))
            return True ,""
        
        #下载文件
        loadSucc = downloadFile(context, cliRet, temfile)
        Log.info("downloadFile is :%s" %(str(loadSucc)) )
        if not loadSucc:
            errMsg = resource.getString('downLoad.file.failure"')
            return (SCRIPT_RET_CODE.FAIL, errMsg)    
        
        return (SCRIPT_RET_CODE.SUCCESS, errMsg)
                
    except Exception:
        Log.error('Failed to collect.fail.msg.runningdata :' + traceback.format_exc())
        errMsg = resource.getString('collect.fail.msg.runningdata ')
        return (SCRIPT_RET_CODE.FAIL, errMsg)
    
