# -*- coding: UTF-8 -*-
import re
import traceback
from cBase4TV1 import *

P_Contain = 0
P_Start = 1
P_End = 2

# *****************************************************************************************#
# 类名称: getLocation(cliRet, subStr, relation = P_Contain)
# 功能说明: 在CLI回显中找到（或以subStr开始，结尾）第一次出现subStr的位置
# 输入参数: cliRet, subStr（字串）, relation = P_Contain（默认为找到）
# 输出参数: location
# *****************************************************************************************#
def getLocation(cliRet, subStr, relation=P_Contain, startIndex=0):
    location = -1
    
    cliRetList = cliRet.splitlines()
    for i in xrange(startIndex, len(cliRetList)):
        lineInfo = cliRetList[i].strip()
        if P_Contain == relation and - 1 != lineInfo.find(subStr):
            location = i
            break
        elif P_Start == relation and lineInfo.startswith(subStr):
            location = i
            break
        elif P_End == relation and lineInfo.endswith(subStr):
            location = i
            break
    return location
 
          
# *****************************************************************************************#
# 类名称: cHandlTypeLine（继承cTypeLine）
# 功能说明: 对于CLI回显，一行为关键字，下面所有行为其对应的value值格式，格式化为一个关键字对应
#           value值的list(dict)结果，value值的行数即为list的长度
# 输入参数: cliRet：开始某行为key值，下方为对应value值CLI回显格式 
#           keyWordList：key值列表，指定需要获取的key值，不指定默认获取全部
#           defaultSep：key行关键字是否有特殊字符分割
#           newLineSign：对于value值存在多行的情况，默认为直接连接
#           areaIndex = [key预计起始位置，value预计结束位置]：指定回显需要处理的范围，默认全部
# 输出参数: cHandlTypeLine.generatListDict()
# *****************************************************************************************# 
class cHandleTypeList(cTypeList):
    
    def __init__(self, cliRet, keyWordList=[], newLineSign="", areaIndex=[None, None]):
        fstKeyEndIndex = -1
        aimKeyPosInfo = {}
        
        if not self.__checkParams(cliRet, keyWordList, areaIndex):
            raise ParseException("Input param error(keyWordList=" + str(keyWordList) + \
                            ",newLineSign=" + str(newLineSign) + ",areaIndex=" + str(areaIndex) + ")")
        
        cliRet = cliRet.encode('utf8')
        
        #获取指定区域的CLI回显list，默认处理全部
        cliRetList = self.getCliRetDoArea(cliRet, areaIndex)
        if not cliRetList:
            cTypeList.__init__(self, cliRetList, fstKeyEndIndex, aimKeyPosInfo, newLineSign)
            return 
        
        #获取keyWord在指定区域中所在行数的索引
        keyWordLinage = self.__getKeyWordLinage(cliRetList, keyWordList)
        if - 1 == keyWordLinage:
           cTypeList.__init__(self, cliRetList, fstKeyEndIndex, aimKeyPosInfo, newLineSign)
           return 
       
        #设置包含key值的行
        self.keyWordLine = cliRetList[keyWordLinage]
        
        #获取所有key值及对应的value值的起始位置
        self.__totalkeyPosInfo = self.__getTotalKeyPosInfo()
        
        #获取指定key值及对应的value值的起始位置
        aimKeyPosInfo = self.getAimKeyPosInfo(self.__totalkeyPosInfo, keyWordList)
       
        #获取第一个key值对应的结束标志
        fstKeyEndIndex = self.__getFirstKeyEndIndex()
    
        cTypeList.__init__(self, cliRetList[keyWordLinage + 1:len(cliRetList)], fstKeyEndIndex, aimKeyPosInfo, newLineSign)
           
        return 

    #入参检查
    def __checkParams(self, cliRet, keyWordList, areaIndex):
        
        #关键字列表传入为空，默认指定为[],方便后续判断
        if not keyWordList:
            keyWordList = []    
        if not cliRet:
            return False
        if list != type(keyWordList):
            return False
        if list != type(areaIndex) and 2 == len(areaIndex):
            return False
        return True
    
    #获取需要处理区域的CLI回显，请传入一个表头+N个value行的结构     
    def getCliRetDoArea(cliRet, areaIndex=[None, None]):
        
        cliRetList = cliRet.splitlines()
        if [None, None] == areaIndex:
            return cliRetList
        elif areaIndex[0] > 0 and None == areaIndex[1]:
            return  cliRetList[areaIndex[0]:len(cliRetList)] 
        elif [None, None] != areaIndex:
            if 2 != len(areaIndex) or areaIndex[0] >= areaIndex[1]:
                return None
            return  cliRetList[areaIndex[0]:areaIndex[1]]
        else:
            return cliRetList
    
    getCliRetDoArea = staticmethod(getCliRetDoArea)
    
    #获取keyWord在指定区域中所在行数的索引
    def __getKeyWordLinage(self, cliRetList, keyWordList):
        keyWordLinage = -1
        
        if not cliRetList:
            return keyWordLinage
        
        if keyWordList:
            #找到key值所在行的下标
            for i in xrange(0, len(cliRetList)):
                if - 1 != keyWordLinage:
                    break
                
                if patternSymbol.match(cliRetList[i]):
                    continue
                
                if patternEnd.match(cliRetList[i]):
                    continue
            
                for keyWord in keyWordList:
                    if not keyWord or not keyWord.strip():
                        break
                    if re.search("\s{2,}" + keyWord.strip().replace('(', '\(').replace(')', '\)') + "\s{2,}", \
                                  cliRetList[i]):
                        keyWordLinage = i
                        break
                    
        #若是通过关键字没有找到或是没有传入关键字，通过模糊匹配的方式常识查找
        if - 1 == keyWordLinage:
           for i in xrange(0, len(cliRetList)):
               if not re.search("[A-Za-z0-9]", cliRetList[i]):
                   continue
               
               elif patternEnd.match(cliRetList[i]):
                   continue
               
               #两个空格之后为非字母，一定非keyWord行
               elif re.search("\s{2,}[^a-zA-Z\s]", cliRetList[i]):
                   continue
               
               #找到两个及以上“  字母”格式，即可判断为包含keyWord的行
               elif len(re.findall("\s{2,}[a-zA-Z]", cliRetList[i])) >= 2:
                   keyWordLinage = i
                   break
               
        return keyWordLinage
    
    #获取所有的keyWord列表
    def __setAllkeyWordList(self):
        
        sList = re.split("\s{2,}", self.keyWordLine)
        for key in sList:
            if key:
                self.allKeyWordList.append(key)
        return
    
    #指定需要获取的key值列表，默认全部
    def __setkeyWordList(self, keyWordList):
        
        if keyWordList:
            self.keyWordList = keyWordList
        else:
            self.keyWordList = allkeyWordList
        return
    
    #获取所有关键字对应value值的起始位置
    def __getTotalKeyPosInfo(self):
        
        totalkeyPosInfo = {}  
        
        keyWordLine = unicode(self.keyWordLine.decode('utf8'))
        
        sList = re.split("\s{2,}", keyWordLine.strip())
        
        valsIndex = []
        for key in sList:
            valsIndex.append(keyWordLine.find(key, valsIndex[-1] + 1 if len(valsIndex) > 0 else 0))    
        valsIndex.append(len(keyWordLine))
            
        #循环所有key找到对应value的起始位置        
        for i in xrange(len(sList)):
            key = sList[i].strip()
            totalkeyPosInfo[key] = [valsIndex[i], valsIndex[i + 1]]
            
        return totalkeyPosInfo
    
    def getAimKeyPosInfo(totalkeyPosInfo, keyWordList):

        aimKeyPosInfo = {}
        
        if dict != type(totalkeyPosInfo):
            return aimKeyPosInfo
        
        if not keyWordList:
            aimKeyPosInfo = totalkeyPosInfo
            return aimKeyPosInfo
        
        for key in keyWordList:
            #异常处理防止指定
            if not key or str != type(key):
                continue
            
            if totalkeyPosInfo.has_key(key.strip()):
                aimKeyPosInfo[key] = totalkeyPosInfo[key.strip()]
                continue
            
            #单位转化时无法指定具体的值，采取不匹配单位的方式
            isFind = False
            for orginKey in totalkeyPosInfo.keys():
                #Temperature(℃)情况，为了防止特殊字符无法计算起始位置，可以指定传入Temperature即可
                if orginKey.startswith(key) and re.match("\W.*\W", orginKey[len(key):]):
                    isFind = True
                    aimKeyPosInfo[key] = totalkeyPosInfo[orginKey]
                    break
           
            #没有找到key,赋值无效
            if not isFind:    
                aimKeyPosInfo[key] = [-1, -1] 
        
        return aimKeyPosInfo     
       
    getAimKeyPosInfo = staticmethod(getAimKeyPosInfo)
            
    #获取第一个key值的结束位置
    def __getFirstKeyEndIndex(self):
        keyWordLine = self.keyWordLine.strip()
        
        index = keyWordLine.find("  ")
        if - 1 == index:
            return - 1
        else:
            return index + 2
        
    #测试接口
    def getKeyWordLinage(self):
        return self.keyWordLinage
    
    def getKeyWordLine(self):
        return self.keyWordLine
    
    def getTotalKeyPosInfo(self):
        return self.__totalkeyPosInfo
    

# *****************************************************************************************#
# 函数名称: cHandleTypeDict（cTypeDict）
# 功能说明: 对于CLI回显，左侧为key值，右测为value值的情况
# 输入参数: cliRet：CLI回显
#           keyWordList：key值列表，指定需要获取的key值，不指定默认获取全部
#           withTitle 为 True：默认套用两层字典，即是否带titleKey信息
#           defaultSep：默认分隔符为"|"
#           newLineSign：对于value值存在多行的情况，默认为直接连接
# 输出参数: withTitle 为 True时：返回一个list,单个元素为只有一个键值的字典，字典里面键值对应为
#           titleKey，titleKey对应的value为多个key值关联value的字典（list(dict(dict))）
#           withTitle 为 False时：返回一个list,不包含titleKey信息，list单个元素为一个字典，相
#           当于只包含具体信息的字典（list(dict)）
# *****************************************************************************************#
class cHandleTypeDict(cTypeDict):
    
    def __init__(self, cliRet, keyWordList=[], withTitle=False, defaultSep="|", newLineSign=""):
        
        if not self.__checkParams(cliRet, keyWordList, withTitle, defaultSep, newLineSign):
            raise ParseException("Input param error(keyWordList=" + str(keyWordList) + \
                            ",withTitle=" + str(withTitle) + ",newLineSign=" + str(newLineSign) + ")")
        
        cliRet = cliRet.encode('utf8')
        #单个元素结构[title名称, title区域对应的开始位置，title区域对应的结束位置]
        titleNameAreaList = self.__getTitleNameAndArea(cliRet) 
        
        cTypeDict.__init__(self, cliRet, titleNameAreaList, keyWordList, withTitle, defaultSep, newLineSign)
        return
    
    def __checkParams(self, cliRet, keyWordList, withTitle, defaultSep, newLineSign):
        
        #关键字列表传入为空，默认指定为[],方便后续判断
        if not keyWordList:
            keyWordList = []
			
        if not cliRet:
            return False
        if list != type(keyWordList):
            return False
        if bool != type(withTitle):
            return False
        if  str != type(defaultSep):
            return False
        
        #分隔符不能只为数字和空格
        if  re.compile("^[\w\s]*$").match(defaultSep):
            return False
        if str != type(newLineSign):
            return False
        return True
    
     #找到title名称及title对应的起始区域信息
    def __getTitleNameAndArea(self, cliRet):
        cliRetList = cliRet.splitlines()
        titleNameAreaList = []
        
        titleLocation = []
        for i in xrange(1, len(cliRetList)):
            if patternSub.match(cliRetList[i]) and i >= 2:
                if patternEqu.match(cliRetList[i - 2]):
                    titleName = cliRetList[i - 1].strip()
                    titleIndex = i - 1
                    titleLocation.append([titleName, titleIndex])
        
        for i in xrange(0, len(titleLocation)):
            titleName = titleLocation[i][0]
            areaStart = titleLocation[i][1]
            
            if i == len(titleLocation) - 1:
                areaEnd = len(cliRetList)
            else:
                areaEnd = titleLocation[i + 1][1]
                
            titleNameAreaList.append([titleName, areaStart, areaEnd])
            
        return titleNameAreaList
    
    #测试接口
    def getTitleNameAreaList(self):
        return self.titleNameAreaList

 
