﻿# -*-coding:utf-8 -*-
from com.huawei.ism.tool.framework.platform.exception import ToolException
from com.huawei.ism.tool.obase.exception import PwdException
from com.huawei.ism.tlv.lang import UnsignedInt32
from com.huawei.ism.tlv.bean import Param
from com.huawei.ism.tlv.docoder import ParamType
from com.huawei.ism.tlv.bean import Record
from com.huawei.ism.tlv import TLVUtils
from common.log import Log
from cliCmdManager import execCmd
import time
from constant import TV2R2_CLI_CMD,CONFIG,TV1_CLI_CMD
import traceback
from frame.context.contextUtil import initCliConnection, getCli, getLang ,getSftp
from frame.cli.cliUtil import excuteCmdInCliMode, getUserPrivilege, getMsg
import os

from constant import CmdConstants
from cliParser import CliParser
from resource import Resource

from contextUtil import getLogger, getSshConnector

import utils
import re
import traceback

def getResource(context):
    '''
    Function describe: Get resource instance.
    Input:            
    Return value:     (resource)
                        
    Revision History: 1. Created 2014-02-21
    '''
    resource = context.get('resource')
    if not resource:
        resource = Resource(context)
        context['resource'] = resource
    
    return resource


def createSshConnector(context):
    '''
    Function describe: Crate SSH connector.
    Input:            
    Return value:     (SshConnector)
                        
    Revision History: 1. Created 2014-02-21
    '''
    
    sshConnectorFactory = context.get('connectorFactory')
                          
    sshConnector = sshConnectorFactory.createSshForwardConnector(context.get('dev'))
    
    return sshConnector




def getSystemStatus4TV1(sshConnector, logger):
    '''
    @summary: Get the system status for TV1 series
    @date: 2014-08-27
    @param logger: the logger which provided by tool
    @return: the status of system
    '''
    
    isSucc, cmdRet = execCmd(sshConnector, TV1_CLI_CMD.SHOW_SYS, logger)
    if not isSucc:
        logger.error('[commonFunction]Execute command [' + TV1_CLI_CMD.SHOW_SYS + '] failed!')
        return ''
    
    modelParse = CliParser(cmdRet, logger, cliType='dict')
    sysInfoDic = modelParse.genDict()
    sysStatus = sysInfoDic.get('Current System Mode')
    logger.info('[commonFunction]Got system status:' + str(sysStatus))
    return sysStatus


def getSystemStatus(sshConnector, logger):
    '''
    Function describe:    Get system status by CLI.
    Return value:         tuple(healthStatus, runningStatus)
                                  
    Revision History:     1. Created 2014-08-18 
    '''
    healthSta = ''
    runningSta = ''
    
    execRet = execCmd(sshConnector, TV2R2_CLI_CMD.SHOW_SYSTEM_GENERAL, logger)
    if not execRet[0]:
        logger.error('Execute command [' + TV2R2_CLI_CMD.SHOW_SYSTEM_GENERAL + '] failed!')
        return (healthSta, runningSta)
    
    cliEcho = execRet[1]
    
    modelParse = CliParser(cliEcho, logger, cliType='dict')
    sysInfoDic = modelParse.genDict()
    healthSta = sysInfoDic.get('Health Status')
    runningSta = sysInfoDic.get('Running Status')
    logger.info('Got system status:' + str((healthSta, runningSta)))
    
    return (healthSta, runningSta)

   
def getDeviceProductModel(sshConnector, logger):
    '''
    Function describe:    Get the product model of controller by CLI.
    Return value:         tuple(boolean, string)
                                  boolean-true if command executed success, false if command executed failed.
                                  string-device product model, e.g., S5500T.
    Revision History:     1. Created 2014-01-07 
    '''
    productModel = ''
    
    execRet = execCmd(sshConnector, TV2R2_CLI_CMD.SHOW_SYSTEM_GENERAL, logger)
    if not execRet[0]:
        logger.error('Execute command [' + TV2R2_CLI_CMD.SHOW_SYSTEM_GENERAL + '] failed!')
        return productModel
    
    cliEcho = execRet[1]
    
    modelParse = CliParser(cliEcho, logger, cliType='dict')
    sysInfoDic = modelParse.genDict()
    productModel = sysInfoDic.get('Product Model')
    logger.info('Got product model:' + str(productModel))
    
    return productModel

def getDeviceProductFullVersion(sshConnector, logger):
    '''
    Function describe:    Get the product version of controller by CLI.
    Return value:         versionString
                                  Non-empty string success, empty string if command executed failed.
                                  string-device product version, e.g., V200R002C00SPC100.
    Revision History:     1. Created 2014-03-04
    '''
    productVer = ''
    
    execRet = execCmd(sshConnector, TV2R2_CLI_CMD.SHOW_UPGRADE_PACKAGE, logger)
    if not execRet[0]:
        logger.error('Execute command [' + TV2R2_CLI_CMD.SHOW_UPGRADE_PACKAGE + '] failed!')
        return productVer
    
    cliEcho = execRet[1]

    endIndex = cliEcho.find('HotPatch Version')
    if endIndex == -1:
        logger.error('CLI command [' + TV2R2_CLI_CMD.SHOW_UPGRADE_PACKAGE + '] echo probably wrong!')
        return ''
        
    versionParser = CliParser(cliEcho[0:endIndex], logger, cliType='dict')
    verInfoDicList = versionParser.genDictList()
    
    for verDic in verInfoDicList:
        productVer = verDic.get('Current Version')
        if productVer:
            logger.info('Got product full version:' + str(productVer))
            return productVer
    else:    
        logger.error('Parse product version failed!')
        return productVer

def getDeviceMemorySize(sshConnector, logger):
    ''''
    Function describe:    Get memory size of controller.
    Return value:         tuple(boolean, string)
                                  boolean-true if command executed success, false if command executed failed.
                                  string-device memory size, e.g., 8.000GB.
    Revision History:     1. Created 2014-01-07 
    '''
    execRet = execCmd(sshConnector, TV2R2_CLI_CMD.SHOW_CONTROLLER_GENERAL, logger)
    if not execRet[0]:
        logger.error('Execute command [' + TV2R2_CLI_CMD.SHOW_CONTROLLER_GENERAL + '] failed!')
        return (False, '')
    
    memSize = ''
    cliEcho = execRet[1]
    for line in cliEcho.splitlines():
        if re.search('Cache Capacity', line, re.IGNORECASE):
            try:
                memSize = line.split(':')[1].strip()
            except Exception, e:
                logger.error('Got memory size caught exception:' + str(e))
                return (False, '')
            else:
                logger.info('Got memory size:' + memSize)
                return (True, memSize)

    return (False, '')


    






def getMgtCfgList(sshConnector, logger):
    ''''
    Function describe:    Get memory size of controller.
    Return value:         tuple(boolean, string)
                                  boolean-true if command executed success, false if command executed failed.
                                  string-device memory size, e.g., 8.000GB.
    Revision History:     1. Created 2014-07-28 
    '''
    nodeMgtCfgList = []
    
    if not sshConnector:
        logger.error('sshConnector is invalid!')
        return nodeMgtCfgList

    if not logger:
        logger.error('LOGGER parameter is invalid!')
        return nodeMgtCfgList    
    
    qryCtrlIpCmd = TV2R2_CLI_CMD.SHOW_CONTROLLER_IP
    
    execRet = execCmd(sshConnector, qryCtrlIpCmd, logger)
    if not execRet[0]:
        logger.error('Execute command [' + qryCtrlIpCmd + '] failed!')
    else:
        cliEcho = execRet[1]
    
        nodeMgtCfgList =  utils.formatVDict2List(cliEcho)
        logger.info('Got MGT CFG:' + str(nodeMgtCfgList))
        
    return nodeMgtCfgList    

def getExpandModuleIdList(sshConnector, logger):
    ''''
    Function describe:    Get expansion module ID list.
    Return value:         list:Expansion module ID' list.

    Revision History:     1. Created 2014-07-28 
    '''
    expModuleIdList = []
    
    qryExpModuleCmd = TV2R2_CLI_CMD.SHOW_EXPANSION_MODULE
    execRet = execCmd(sshConnector, qryExpModuleCmd, logger)
    if not execRet[0]:
        logger.error('Execute command [' + qryExpModuleCmd + '] failed!')
    else:
        cliEcho = execRet[1]
    
        expModuleDictList =  utils.formatHDict2List(cliEcho)
        logger.info('Got expansion module list:' + str(expModuleDictList))
        
        for expModuleDict in expModuleDictList:
            expModuleIdList.append(expModuleDict['ID'])
            
    return expModuleIdList 

def getCtrlEleLblStringList(sshConnector, logger):
    ''''
    Function describe:    Get expansion module ID list.
    Return value:         list:Expansion module ID' list.

    Revision History:     1. Created 2014-07-28 
    '''
    
    qryCtrlCmd = TV2R2_CLI_CMD.SHOW_CONTROLLER_GENERAL
    execRet = execCmd(sshConnector, qryCtrlCmd, logger)
    if not execRet[0]:
        logger.error('Execute command [' + qryCtrlCmd + '] failed!')
        return []
    else:
        cliEcho = execRet[1]
    
        ctrlInfoDictList =  utils.formatVDict2List(cliEcho)
        logger.info('Got controller list:' + str(ctrlInfoDictList))
        return ctrlInfoDictList 
    
def formatEletricLabelToDict(electricLbl):
    ''''
    Function describe:    Format electrical label string to a dictionary.
    Return value:         list:Expansion module ID' list.

    Revision History:     1. Created 2014-07-28 
    '''    
    eleLblDict = {}
    for line in electricLbl.splitlines():
        if '=' in line:
            key = line.split('=')[0].strip()
            val = line.split('=')[1].strip()
            eleLblDict[key] = val
    
    return eleLblDict
              
    
def isSshConnectionNormal(context):
    '''
    @summary: Check if the SSH connection is normal
    @param context: context object
    @return: 
    '''
    logger = getLogger(context)
    sshConnector = getSshConnector(context)
    if not sshConnector.getConnectionNoException():
        logger.error('[commonFunction] Get SSH connection failed!')
        return False
    else:
        logger.info('[commonFunction] Get SSH connection successfully!')
        return True
   
def excuteCmd(context, commond):
    initCliConnection(context)   
    cli = getCli(context)
    lang = getLang(context)
    return excuteCmdInCliMode(cli, commond, True, lang)


def checkSystemNormal(context):
        '''
                    函数名称: checkSystemNormal
                    功能说明: 检验当前设备是否normal
                    输入参数: context
                    输出参数: True, False
        '''
        flag = False
        cmd = "show system general"        
        (isSuccess, cliRet,errMsg) =  excuteCmd(context, cmd)
        if not isSuccess:
            lang = getLang(context)
            errMsg = getMsg(lang, "dev.conn.failure")
            return False ,errMsg
        
        if re.search("System Name", cliRet, re.IGNORECASE):
            flag = True ,errMsg
        else:
            errMsg = getMsg(lang,  'system.abnormal')
            return False ,errMsg
        return flag ,errMsg

def checkUserPrivilege(context, type=None):
        '''
        @summary: 检查用户权限，用户权限为["Super_admin" 或  "Admin"],则返回True，否则返回False
        @param cliRet: context=上下文对象
        @return: userLevel
        '''
        cli = getCli(context)
        lang = getLang(context)
        result = False
        (isSuccess, userLevel,errMsg) = getUserPrivilege(context, cli, lang)
        Log.info("userLevel is : %s" %(str(userLevel)) )
        if not isSuccess:
            lang = getLang(context)
            errMsg = getMsg(lang, "dev.conn.failure")
            return False ,errMsg
        
        privileges = ["Super Administrator", "Administrator"]
            
        if userLevel in privileges:
            result = True
        else:
            errMsg = getMsg(lang, "user.level.low")
            return False ,errMsg
        return result,errMsg

def getCurrentDate():
        '''
        @summary: 获取本地当前时间
        @param cliRet: devObj=上下文对象
        @return: localDir
        '''
        result = str(time.strftime('%Y%m%d%H%M%S',time.localtime(time.time())))
        return result


           
def getLocalDir(context):
        '''
        @summary: 获取用户选择的路径
        @param cliRet:  devObj=上下文对象
        @return: localDir:用户选择的路径
        '''
        localDir = context.get("configFileLocalPath")
        return localDir

       
def deleteRemoteFile(context, sftp, serverPath):
        '''
        @summary: 删除阵列端生成的文件
        @param cliRet:  devObj=上下文对象
                        type=收集的类型
                        rec=CLI回显信息
        @return:Bool(True or False)
        '''
        try:
            sftp.deleteFile(serverPath)
            Log.info("delete file  success, serverPath is %s" %str(serverPath))
            ####异常处理
        except Exception:
            Log.info("delete file  filed, serverPath is %s" %str(serverPath))
            Log.error('Failed to delete file :' + traceback.format_exc())
            pass
                    
def downloadFile(context, cliRet, temfile):
        '''
        @summary: 下载收集到得文件信息到本地
        @param cliRet:  devObj=上下文对象
                        type=收集的类型
                        cliRet=命令执行成功的回显
        @return: True or False
        '''
        try:
            """通过SFTP下载文件，并和框架侧交互，将文件或者文件路径反馈给框架，最终生成档案收集结果"""
            
            devObj = context.get("dev")
            productSn = devObj.deviceSerialNumber
            userlocalDir =getLocalDir(context)
            ip =devObj.getIp()
            
            #当IP为IPV6格式时，工具进行兼容
            ip = str(ip).replace(":",".")
            Log.info("current IP is :%s " %str(ip))
            
            #获取阵列端存放信息的路径和文件名称
            listRemotePaths = getRemotePathAndName(context, cliRet)
            
            #获取时间戳
            productTime = getCurrentDate()                      
            
            localDir = userlocalDir + os.path.sep + ip 
            Log.info("localDir is :%s " %str(localDir))
            if not os.path.exists(localDir):
                os.makedirs(localDir)
                
            #下载运行数据到本地的目录信息
            sftp = getSftp(context)
        
            #分离文件名与扩展名
            runDataNamelist = os.path.splitext(temfile)
            fileName = runDataNamelist[0]
            #收集文件名称与V3版本保持一致，强制转换为config
            fileName = "config"
            fileNameExtension = runDataNamelist[1]
            newRunningDataName = "%s_%s_%s%s" %(str(fileName), str(productSn), str(productTime), str(fileNameExtension))
            
            #阵列文件路径
            serverPath = "/OSM/export_import/OSM_sysconfig.txt"
            RunningDataNamename = "OSM_sysconfig.txt"
            Log.info("serverPath is :%s " %str(serverPath))
            #通过SFTP协议将阵列文件下载到本地
            sftp.getFile(str(serverPath),localDir, None)
            
            #更改文件名名称，加上SN号和时间戳
            old = unicode(localDir + os.path.sep + RunningDataNamename)
            new = unicode(localDir + os.path.sep + newRunningDataName)
            Log.info("localDir and filename is :%s " %str(old))
            Log.info("serverPath and filename is is :%s " %str(new))
            os.rename(old, new)                
            Log.info( "get file success, and delete file")
            #删除阵列段文件
            deleteRemoteFile(context, sftp, serverPath)
                
            return True
        except:
            Log.info("except trace back:" + str(traceback.format_exc()))
            return False
    
def getRemotePathAndName(context, cliRet):
        '''
        @summary: 获取阵列端的文件名称和路径
        @param cliRet:  context=上下文对象
        @return: name:阵列端产生的文件名称
                 path:阵列端产生的文件的路径
        '''
        resultList = []
        cliRetList = cliRet.splitlines()
        for line in cliRetList:
            #判断回显是否正常
            if CONFIG.COLLECT_INFO_RECROD_STANDARD in line:
                tempDict = {}
                tempList = line.split(" : ")
                path = tempList[1]
                tempList1 = path.split("/")
                name = tempList1[-1]
                tempDict["path"] = path
                tempDict["name"] = name
                resultList.append(tempDict)
        
        return resultList
    
def isExistCmdForRec(rec):
        '''
                    根据命令回显信息，判断当前命令是否在系统中存在
                    判断标准：若在回显中出现 '^'符号，则当前命令不存在
        '''
        CLI_NOT_EXIST_FLAG = "^"
        if None == rec:
            return False
        
        if CLI_NOT_EXIST_FLAG in rec:
            return False
        
        return True
    
def getIpList(context):
    
    strCmd = "showctrlip"
    isSuccess,cliRet ,errMeg  = excuteCmd(context,strCmd)
    list = cliRet.splitlines()
    
    #初始化过程变量
    ctrlId = ""
    ipv4Add = ""
    
    #返回信息
    nodeIpsDictList = []
    nodeIpsDict = {"node": "", "ipList": []}
    
    #获取控制器ID与ip的map关系
    for line in list:
        #获取控制器ID
        if re.search("Controller", line, re.IGNORECASE):
            ctrlId = line.split()[-1].strip()
            continue
        #获取IPV4地址
        elif re.search("IPv4 Address", line, re.IGNORECASE):
            ipv4Add = line.split()[-1].strip()
            #获取控制器ID与Ip对应关系，并保存到列表中
            if ipv4Add and len(ctrlId) == 2:
                #获取节点ID
                nodeId = ctrlId[0]
                
                #初始化信息
                nodeExist = False
                nodeIpsDict = {"node": "", "ipList": []}
                
                #更新已存在的节点信息
                for index in range(len(nodeIpsDictList)):
                    if nodeIpsDictList[index]["node"] == nodeId:
                        nodeExist = True
                        nodeIpsDictList[index]["ipList"].append(ipv4Add)
                        break
                #节点不存在，创建节点信息
                if not nodeExist:
                    nodeIpsDict["node"] = nodeId
                    nodeIpsDict["ipList"].append(ipv4Add)
                    nodeIpsDictList.append(nodeIpsDict)
                
                #初始化信息
                ctrlId = ""
                ipv4Add = ""                   
        else:
            continue
    
    return nodeIpsDictList
