﻿# -*- coding:utf-8 -*-

CMD_DEFAULT_TIMEOUT = 180


class CmdRetOrientation():
    horizontalLst = ("controller IP",
                     "LUN WORM",
                     "target on controller A",
                     "target on controller B",
                     "SmartCache LUN",
                     "system upgrade package",
                     "cold patch upgrade package",
                     "hot patch upgrade package",
                     "bond port",
                     "enclosure",
                     "FC mode",
                     "FC speed",
                     "FC module",
                     "ISCSI IP",
                     "ISCSI port MTU",
                     "ISCSI route",
                     "port",
                     "power",
                     "disk physic",
                     "disk logic",
                     "extending LUN",
                     "resource pool",
                     "LUN in resource pool",
                     "array port",
                     "free array port",
                     "host free port",
                     "host",
                     "host group",
                     "map",
                     "host port",
                     "pool",
                     "remote replication consistent group member",
                     "remote replication consistent group",
                     "remote replication member",
                     "third party LUN",
                     "LUN of period snapshot",
                     "period snapshot",
                     "split mirror",
                     "split mirror consistent group",
                     "split mirror consistent group member",
                     "mirror LUN",
                     )


class PosMap():
    ctrlOrBBUslotposMap4TV1 = {'S2200T':'slotpos=1', #1表示后插板,0表示前插板
                    'S2200T-S':'slotpos=1',
                    'S2600T':'slotpos=1',
                    'S2900':'slotpos=1',
                    'S3900-M200':'slotpos=1',
                    'S3900-M300':'slotpos=1',
                    'S5500T':'slotpos=1',
                    'S5600T':'slotpos=0',
                    'S5800T':'slotpos=0',
                    'S5900-M100':'slotpos=0',
                    'S5900-M200':'slotpos=0',
                    'S6800T':'slotpos=0',
                    'S6900-M100':'slotpos=0',
                    'S8000-I':'slotpos=0'}

class SCRIPT_RET_CODE():
    FAIL = 0
    SUCCESS = 1
    PART_SUCCESS = 2
    
#Frame interface error code.
class ConnectionErrCode():
    #SSH: getConnection error code.
    SSH_AUTH_FAIL = '1'
    SSH_CONNECT_EXCEPTION = '2'
    SSH_USR_STA_ABNORMAL = '3'
    SSH_DEV_STA_ABNORMAL = '4'
    SSH_OTHER_ERROR = '9'
    
    
class RET_CODE():
    EXEC_FAILED = -1
    RET_SUCCESS = 0
    PARSE_TLV_EXCEPT = 1
    PARSE_CLI_EXCEPT = 2
    EXE_OK_NOT_PASS = 3
    
class CmdConstants:
    CLI_EXECMD_RETRY_TIMES = 3
    CLI_RETRY_INTERVAL_TIME = 5
    CLI_DEFAULT_TIMEOUT = 300

    TLV_INVOKE_RETRY_TIMES = 3
    TLV_RETRY_INTERVAL_TIME = 5
    CLEAR_DB_TIMEOUT = 150
    TLV_DEFAULT_TIMEOUT = 300
    

class T_V2_FactoryCfg():
    SSH_PORT = 22
    TLV_PORT = 8080
    DEF_USERNAME = 'admin'
  
    
class TV2R2_TLV_CMD():
    MODIFY = 55834583040
    COUNT = 55834632192
    GET = 55834574848
    GET_BATCH_NEXT = 55834624000
    
    
class TV1_CLI_CMD():
    SHOW_SYS = 'showsys'
    
    
class TV2R2_CLI_CMD():
    SHOW_ALARM = 'show alarm'
    SHOW_SYSTEM_GENERAL = 'show system general'
    SHOW_EXPANSION_MODULE = 'show expansion_module '
    SHOW_CONTROLLER_GENERAL = 'show controller general'
    SHOW_CONTROLLER_IP  = 'show controller ip '
    CHG_CTRL_MGT_IPV4 = 'change controller ipv4_address'
    SHOW_BBU_GENERAL = 'show bbu general' #电池
    SHOW_POWER_SUPPLY = 'show power_supply'#电源
    SHOW_FAN = 'show fan'
    SHOW_INTERFACE_MODULE = 'show interface_module' #接口模块
    SHOW_DISK_GENERAL = 'show disk general'
    SHOW_EXPANSION_MODULE = 'show expansion_module'
    SHOW_ENCLOSURE = 'show enclosure'
    SWITCH_TO_DEVELOPER = 'change user_mode current_mode user_mode=developer'
    SHOW_VERSION_ALL= 'show version all'
    SHOW_UPGRADE_PACKAGE= "show upgrade package"
    
    SHOW_PORT_GENERAL = 'show port general'
    SHOW_PORT_GENERAL_PCIE='show port general physical_type=PCIE'
    SHOW_PORT_GENERAL_ETH='show port general physical_type=ETH'
    SHOW_PORT_GENERAL_SAS='show port general physical_type=SAS'


class CLI_CMD_Prompt():
    ADMIN = 'admin:'
    DEVELOPER = 'developer:'
    MINISYSTEM = 'minisystem'
    DIAGNOSE = 'diagnose>'
    STORAGE = 'Storage:'
    

class CONFIG():

    EXPORT_TYPE_RUNNING_DATA = "running_data"

    COLLECT_INFO_RECROD_STANDARD = "File Path :"

    DELETE_REMOTE_DATA_STANDARD = [
                                       "System is exporting files"
                                       
                                       ]
    

    EXPORT_INFO_TIMEOUT = { 
                               EXPORT_TYPE_RUNNING_DATA:23*60,
                               
                               }
    
    TV1R5_STRRET = "Error: Failed to transfer the file."
    TV1R1_STRRET = "File was transfered failed!"
    
