# -*- coding: UTF-8 -*-

import re
    
def formatHDict2List(descStr):
    
    '''
    Function describe:    将list样式字符串转换成list对象
    Return value:         由多个dict对象组成的list
    Revision History:     1. Created 2014-02-26 
    Remark:               可选输入参数descStr，若不传此参数则默认解析成员变量cliEcho
    '''
    
    # 由---和空格构成行的行号，大于等于1
    REF_LINE_NO = None                              
    # 最后需要返回的结果
    result = []
    # 存放各列数据的开始位置/结束位置
    valsIndex = []
    # 将字符串拆成单行并存放在list对象中
    lsts = descStr.splitlines()                    
    #正则表达式，以空格隔开的由多个-构成的字符串（首尾空格不限）

    # 尝试找到符合正则表达式的行
    for i in xrange(len(lsts)):
        if lsts[i].count('-') > 0 and lsts[i].count(' ') + lsts[i].count('-') == len(lsts[i]):
            # 确定行号
            REF_LINE_NO = i
            # 确定列取值的开始位置
            valsIndex.append(lsts[i].find("-"))
            break
        
    # 如果没有找到符合正则表达式的行号，意味着格式不符合，不再继续解析，直接返回空结果    
    if not REF_LINE_NO:
        return result

    # 取出---和空格构成的行
    strVals = lsts[REF_LINE_NO] 

    while valsIndex[-1] != -1:
        #依次取出“ -”所在的位置并添加到valsIndex，直到取到-1为止
        valsIndex.append(strVals.find(" -", valsIndex[-1] + 1))    
    #将最后一位设为字符串长度，最后一次取值直接取到末尾
    valsIndex[-1] = len(strVals)
    
    # 在各dict中作为键值的list
    keys = []   
    # 计算key值，以valsIndex中的两个相临值作为开始位置和结束位置，并去除空格
    for i in xrange(1, len(valsIndex), 1):
        key = lsts[REF_LINE_NO - 1][valsIndex[i - 1]:valsIndex[i]].strip()
        #判断是否有重复存在的列名，若存在则追加一个下标
        if keys.count(key) > 0:
            temp = 1
            while keys.count(key + "_" + str(temp)) != 0:
                temp += 1
            key = key + "_" + str(temp)
  
        keys.append(key)

    # 取出---下面的单行进行解析
    for i in xrange(REF_LINE_NO + 1, len(lsts), 1):
        
        # 排除最后一行，若遇到最后一行则退出循环
        if isEndLine(lsts[i]):            
            break
        #遇到空行时忽略
        if lsts[i].count(' ') == len(lsts[i]):
            continue
        
        # 单行dict中作为value值的list        
        vals = []    
        # 计算单行的value值，以valsIndex中的两个相临值作为开始位置和结束位置，并去除空格
        for j in xrange(1, len(valsIndex), 1):
            vals.append(lsts[i][valsIndex[j - 1]:valsIndex[j]].strip())

        # 单行value计算完成后，与key值合并成dict添加到result结果集中
        result.append(dict(zip(keys, vals)))  
    # 所有行解析完成后返回result结果集
    return result


def formatVDict2List(descStr, simpleMode=False):
    '''
    Function describe:    将dict样式字符串转换成由dict构成的List对象
    Return value:         由多个dict对象组成的list
    Revision History:     1. Created 2014-02-26 
    Remark:               1.可选输入参数descStr，若不传此参数则默认解析成员变量cliEcho
                          2.可选输入参数simpleMode，以若不传此参数则默认False,是否为简单模式，
                                                                                若为True则所有Value值解析成字符串,若为False则会对Value作进一步的解析
    '''
        
    # 最后需要返回的结果
    result = []
    # 将字符串拆成单行并存放在list对象中
    lsts = descStr.splitlines()
    # 用于分隔两个字典的单行，整行都由---构成
    # 用于匹配”--------  xxx Key : ---------“这类字符串以作为Key值
    # dict中的键集合
    keys = []
    # dict中的值集合
    vals = []                               

    #当前所读取的行号
    i = 0 
    while i < len(lsts):
        
        str_line = lsts[i] #缓存此行
        
        #遇到最后一行则退出while循环
        if isEndLine(str_line):
            break
        
        i += 1 #行号+1，准备读取下一行数据

        # 如果遇到整行都是---，将键值对添加到result中并重新初始化key和val
        if str_line.strip().count('-')>0 and  str_line.strip().count('-')  == len(str_line.strip()):
            result.append(dict(zip(keys, vals)))
            keys = []
            vals = []
            continue
        
        # 找到冒号所在的位置   
        index = str_line.find(":")        
        # 当冒号存在时，将冒号前的字符串添加到key中，冒号后的字符串添加到val中，均需要去除前后的字符串
        if index != -1:
            #该行中格式类似”------  key:  ------“
            str_line = str_line.rstrip()
            if str_line.endswith('-') and str_line.startswith('-') and str_line.strip('-').strip().endswith(':') and not simpleMode:
                key = str_line[:index].strip('-').strip()
                val = ""
                #追加键
                keys.append(key)
                #此while语句用于拼接字符串
                while i < len(lsts):
                    str_line = lsts[i].strip()
                    if str_line.endswith(":") or (str_line.endswith('-') and str_line.startswith('-') and str_line.strip('-').strip().endswith(':')) or str_line.find(":/>") != -1:
                        break
                    else:
                        val = val + "\r\n" + str_line               
                        i += 1 #行号+1，准备读取下一行数据
                val = formatStr(val) #退出while循环时需要对key值进行格式化,递归调用
                vals.append(val)             
                continue
            #else中处理Key ： value的结构,value可以为空
            else:
                key = str_line[:index].strip()
                #因为有时候键后面为一堆空格，这里为特殊处理，空格不当成空处理，但保存时仍然存空（即else中的处理）
                val = str_line[index + 1:]
                #追加键
                keys.append(key)
                #若同行取到的value值为空，则认为从下一行开始才是该key的value值，在这种情况下value又将是一个Dict或List对象
                if val == "":
                    #此while语句用于拼接字符串，直到再次遇到以冒号结尾或者包含":/>"情况
                    while i < len(lsts):
                        str_line = lsts[i]
                        if str_line.endswith(":") or isEndLine(str_line):
                            break
                        else:
                            val = val + "\r\n" + str_line               
                            i += 1 #行号+1，准备读取下一行数据

                    if not simpleMode:
                        val = formatStr(val) #退出while循环时需要对key值进行格式化,递归调用
                else:
                    val = val.strip() 
                vals.append(val)               
                continue        
        
        # 若某行是[Board Properties]的集合时暂时未做处理，会忽略掉后面的行
        
    #此行已退出while循环
    result.append(dict(zip(keys, vals)))

    return result



def formatStr(descStr):
    '''
    Function describe:    在不确定字符串样式自动判断样式并转换成dict构成的List对象（也可能直接返回字符串）
    Return value:         由多个dict对象组成的list，或者字符串
    Revision History:     1. Created 2014-02-26 
    Remark:               1.可选输入参数descStr，若不传此参数则默认解析成员变量cliEcho
    '''
    
    lsts = descStr.strip().splitlines()
    if len(lsts) == 0:
        return ""
    #以show开头的认为是命令行，直接排除
    if lsts[0].startswith("show "):
        lsts.pop(0)
        
    for i in xrange(len(lsts)):
        if "" != lsts[i].strip():
                      
            #若字符串中带有冒号，则认为是
            if lsts[i].find(":") != -1:
                return formatVDict2List(descStr)
            
            #当不带冒号且次行符合由多个---与空格组成的格式
            elif i + 1 < len(lsts) - 1:
                if lsts[i + 1].count('-') > 0 and lsts[i + 1].count(' ') + lsts[i + 1].count('-') == len(lsts[i + 1]):
                    return formatHDict2List(descStr)
                
            #若无法确定格式则直接返回该字符串（去除命令行,最后的结束及前后的空白）
            else:
                if isEndLine(lsts[-1]):
                    lsts.pop()
                    
            return "\r\n".join(lsts).strip()


def splitByblanckLine(descStr):
    '''
    Function describe:    按空行分隔字符串
    Return value:         字符串组成的序列
    Revision History:     1. Created 2014-02-26 
    Remark:               1.可选输入参数descStr，若不传此参数则默认解析成员变量cliEcho
    '''
    
    list = descStr.splitlines()
    #去除前端空行
    while len(list) > 0:
        if list[0].count(' ') == len(list[0]):
            list.pop(0)
        elif list[-1].count(' ') == len(list[-1]):
            list.pop()
        else:
            break
    
    result = []
    lines = []
    for line in list:
        if line.count(' ') == len(line):
            if lines:
                result.append("\r\n".join(lines))
                lines = []
        else:
            lines.append(line)
    return result

def isEndLine(descStr):
    '''
    Function describe:    判断是否为结束行
    Return value:         True/False
    Revision History:     1. Created 2014-02-26 
    Remark:               
    '''
    descStr = descStr.strip()
    return descStr.find(':/') != -1 and descStr.endswith('>')


def checkCliInfoValid(cliInfo, necessaryData=False):
    '''
    @summary: 查询当前获取的Cli信息是否有效
    @date: 2014-09-04
    @param cliInfo: context object
    @param necessaryData: 阵列系统中必须包含的配置为True（如控制器、框等）（boolean）
    @return: (isExecSuc, isParsable) as (boolean, boolean)
    '''
    isExecSuc = False
    isParsable = False
    if re.search("-bash", cliInfo, re.IGNORECASE):
        return (isExecSuc, isParsable)
    
    #命令回文大于5行，说明必然有数据
    lineList = cliInfo.splitlines()
    if len(lineList) >= 5:
        isExecSuc = True
        isParsable = True
        return (isExecSuc, isParsable)

    #阵列系统中必须包含的配置（如控制器、框等）
    if necessaryData:
        return (isExecSuc, isParsable)

    #非必需配置项，按照如下标准检查
    if re.search("command operates successfully", cliInfo, re.IGNORECASE):
        isExecSuc = True
    elif re.search("command executed successfully", cliInfo, re.IGNORECASE):
        isExecSuc = True
    elif re.search("license", cliInfo, re.IGNORECASE):
        isExecSuc = True
    elif re.search("not exist", cliInfo, re.IGNORECASE):
        isExecSuc = True
    elif re.search("not support", cliInfo, re.IGNORECASE):
        isExecSuc = True
    elif re.search("help -c ", cliInfo, re.IGNORECASE):
        isExecSuc = True
    
    return (isExecSuc, isParsable)


def getTranslatedCartesianRet(list1, list2):
    '''
    @summary: make Cartesian product of list1 and list2, then translate it into string list
    @date: 2014-07-30
    @paramDict list1: first list
    @paramDict list2: second list
    @return: a string list which stand for the result of Cartesian product
    '''
    
    tmpList = []
    cpRet = getCartesianProduct(list1, list2)
    for tmpTuple in cpRet:
        tmpStr = ''
        #translate the result of Cartesian product(like a list of tuple) into string list
        for i in range(len(tmpTuple)):
            tmpStr += tmpTuple[i] + ' '
        tmpList.append(tmpStr.strip())
    return tmpList


def getCartesianProduct(list1, list2):
    '''
    @summary: make Cartesian product of list1 and list2
    @date: 2014-07-31
    @paramDict list1: first list
    @paramDict list2: second list
    @return: the result of Cartesian product
    '''
    retList = []
    for elem1 in list1:
        for elem2 in list2:
            retList.append((elem1, elem2))
    return retList

