# -*- coding: UTF-8 -*-
from common.commonFunction import checkUserPrivilege,isExistCmdForRec,downloadFile,getResource,isSshConnectionNormal,getIpList
from common.constant import CONFIG,SCRIPT_RET_CODE
import traceback
import socket
from common.log import Log
from common.commonFunction import excuteCmd,downloadFileForOldVersion
from frame.context.contextUtil import initCliConnection
from cbb.frame.util import public_ip_address_utils

def execute(context):
    try:
        errMsg = ""
        #CLI连接初始化
        initCliConnection(context)
        #创建SSH连接
        resource = getResource(context)
        if not isSshConnectionNormal(context):
            errMsg = resource.getString('dev.conn.failure')
            return (SCRIPT_RET_CODE.FAIL, errMsg)
       
        #检查用户级别是否满足收集信息
        isPrivilege ,errMsg = checkUserPrivilege(context)
    
        if not isPrivilege:
            return False , errMsg      
        
        #执行收集Config.TXT文件的业务流程
        myname = socket.getfqdn(socket.gethostname())
        myaddr = socket.gethostbyname(myname)
        ipAddr = public_ip_address_utils.get_export_config_used_ip()
        ipList = getIpList(context)
        ipList.append(myaddr) 
        Log.info("ipList is :%s" %(str(ipList)) )
        if ipAddr in ipList:
            ipAddr = public_ip_address_utils.get_export_event_used_ip()
        
        Log.info("ipAddr is :%s" %(str(ipAddr)) )
        strCmd = "show file export_path file_type=running_data"
        isSuccess,cliRet ,errMeg  = excuteCmd(context,strCmd)
        
        if -1 != cliRet.find("^"):
            strCmd_old = "export running_data ip=" + ipAddr + " user=admin password=****** running_data_file=/collect_sysconfig.txt clean_device_file=no"
            Log.info("The cli order is not supported by current divice, try old cli order:" + strCmd_old)            
            isSuccess,cliRet ,errMeg  = excuteCmd(context,strCmd_old)
            Log.info("old version cliRet is : %s" % str(cliRet))
            if CONFIG.TV2R2_OLD_STRRET in cliRet:
                #下载老版本运行数据文件
                loadSucc = downloadFileForOldVersion(context, CONFIG.EXPORT_TYPE_RUNNING_DATA)
                Log.info("downloadFile is :%s" %(str(loadSucc)) )
                if not loadSucc:
                    errMsg = resource.getString('downLoad.file.failure"')
                    return (SCRIPT_RET_CODE.FAIL, errMsg)    
                
                return (SCRIPT_RET_CODE.SUCCESS, errMsg)            
            else:
                Log.info("execute old version cliRet is :%s" %(str(cliRet)) ) 
                return False ,errMeg 
       
        if not isSuccess:
            return False ,errMeg   
        
        existCmd = isExistCmdForRec(cliRet)
        if not existCmd:
        #命令不存在，表示环境版本过低，直接收集成功
            Log.info("commend not exist %s" % str(cliRet))
            return True ,""
        
        #下载运行数据文件
        loadSucc = downloadFile(context, CONFIG.EXPORT_TYPE_RUNNING_DATA, cliRet)
        Log.info("downloadFile is :%s" %(str(loadSucc)) )
        if not loadSucc:
            errMsg = resource.getString("downLoad.file.failure")
            return (SCRIPT_RET_CODE.FAIL, errMsg)    
        
        return (SCRIPT_RET_CODE.SUCCESS, errMsg)
                
    except Exception:
        Log.error('Failed to collect.fail.msg.runningdata :' + traceback.format_exc())
        errMsg = resource.getString('collect.fail.msg.runningdata')
        return (SCRIPT_RET_CODE.FAIL, errMsg)
    
