﻿# -*- coding: UTF-8 -*-
from time import sleep
from constant import CmdConstants
from constant import CLI_CMD_Prompt
from exception import DisconnectionException

def execCmd(sshConnector, cmd, logger):
    '''
    Function describe:    Execute CLI command interface.
    Return value:         (boolean, cliRet)    

    Revision History:     1. Created 2014-02-21 
    '''
    
    if not sshConnector or not cmd or not logger:
        logger.error('Parameter invalid when execute CLI command!')
        return (False, None)
    
    ssh = sshConnector.getConnectionNoException()
    
    cliRet = ''
    exceptionTimes = 0
    
    while exceptionTimes < CmdConstants.CLI_EXECMD_RETRY_TIMES: 
        try:
            cliRet = ssh.execCmdWithTimout(cmd, CmdConstants.CLI_DEFAULT_TIMEOUT)
        except:
            logger.error('[cliCmdManager.py]-execute command[' + cmd + '] exception!')
            
            sleep(CmdConstants.CLI_RETRY_INTERVAL_TIME)
            exceptionTimes += 1
            
            logger.warn('Try to get SSH connection again!')
            ssh = sshConnector.getConnectionNoException()
        else:
            if cliRet.strip().endswith(CLI_CMD_Prompt.STORAGE):
                try:
                    ssh.close()
                except:
                    pass
                finally:
                    ssh = sshConnector.getConnectionNoException()
            else:
                logger.info('Execute command[' + cmd + '] successfully, return now!')
                return (True, cliRet)
    else:
        logger.error('Execute command[' + cmd + '] exception 3 times!')
        raise DisconnectionException
    
