﻿# -*- coding:utf-8 -*-
from com.huawei.ism.tlv.lang import UnsignedInt32
from com.huawei.ism.tlv.bean import Param
from com.huawei.ism.tlv.docoder import ParamType
from com.huawei.ism.tlv.bean import Record
from com.huawei.ism.tlv import TLVUtils
from com.huawei.ism.exception import IsmException
from com.huawei.ism.tool.framework.pubservice.exception import ConnectionException
from com.huawei.ism.tool.framework.platform.exception import ToolException

from cliCmdManager import execCmd

from constant import T_V2_FactoryCfg,CMD_DEFAULT_TIMEOUT
from constant import RET_CODE,CmdConstants
import commonFunction 

class DevNode():
    def __init__(self, context):
        dev = context.get("dev")
        self.logger = context.get('logger')
        self.deviceName = dev.getDeviceName()
        self.sn = dev.getDeviceSerialNumber()
        self.localIP = dev.getIp()
        self.peerIP = dev.getPeerIp()
        self.sshPort = dev.getPort()
        self.userName = dev.getLoginUser().getUserName()
        self.userPassword = dev.getLoginUser().getPassword()
        self.devPwd = dev.getDeveloperPwd()
        self.lang = context.get('lang')
        
    def __str__(self):
        return ('sn:' + str(self.sn)
                + '\n' + 'localIP:' + str(self.localIP)
                + '\n' + 'peerIP:' + str(self.peerIP)
                + '\n' + 'sshPort:' + str(self.sshPort)
                + '\n' + 'userName:' + str(self.userName)
                + '\n' + 'lang:' + str(self.lang))
                
    def __CreateSshConnector(self, context):
        '''
        Function describe: Crate SSH connector.
        Input:            
        Return value:     (None)
                            
        Revision History: 1. Created 2014-07-28
        '''
        self.sshConnector = commonFunction.createSshConnector(context) 
        return     
    
    def getSshConnector(self, context):
        '''
        Function describe: Crate SSH connector.
        Input:            
        Return value:     (None)
                            
        Revision History: 1. Created 2014-07-28
        '''
        try:
            return self.sshConnector
        except:
            self.__CreateSshConnector(context)
            return self.sshConnector
        else:
            pass
        
    
    def isSystemNormal(self, context):
        isSysNormal = True
        sshConnector = self.getSshConnector(context)
        healthSta, runningSta = commonFunction.getSystemStatus(sshConnector, self.logger)
        if not healthSta or (healthSta.lower() != 'normal'):
            self.logger.error('Health status is not normal.')
            isSysNormal = False
        
        if not runningSta or (runningSta.lower() != 'normal'):
            self.logger.error('Running status is not normal.')
            isSysNormal = False  
            
        return  isSysNormal
        
    def getSysMgtCfgList(self, context):
        sshConnector = self.getSshConnector(context)
        return commonFunction.getMgtCfgList(sshConnector, self.logger)
    
    

    
    
    
  
  

 
    
    def getDeviceProductModel(self, context):
        '''
        Function describe:    Get the product model of controller by CLI.
        Return value:         tuple(boolean, string)
                                      boolean-true if command executed success, false if command executed failed.
                                      string-device product model, e.g., S5500T.
        Revision History:     1. Created 2014-07-28 
        '''
        logger = self.logger
        sshConnector = self.getSshConnector(context)
      
        return commonFunction.getDeviceProductModel(sshConnector, logger)    
    
    def getDeviceFullSystemVersion(self, context):
        '''
        Function describe:    Get the product model of controller by CLI.
        Return value:         tuple(boolean, string)
                                      boolean-true if command executed success, false if command executed failed.
                                      string-device product model, e.g., S5500T.
        Revision History:     1. Created 2014-07-28 
        '''
        logger = self.logger
        sshConnector = self.getSshConnector(context)
      
        return commonFunction.getDeviceProductFullVersion(sshConnector, logger)      
    
    def getDeviceMemorySize(self):
        ''''
        Function describe:    Get memory size of controller.
        Return value:         tuple(boolean, string)
                                      boolean-true if command executed success, false if command executed failed.
                                      string-device memory size, e.g., 8.000GB.
        Revision History:     1. Created 2014-07-28
        '''
        logger = self.logger
        
        (exeSucc, memSize) = commonFunction.getDeviceMemorySize(self.sshConnector, logger)
        if not exeSucc:
            logger.error('Query memory size failed.')
            return (False, '')
        else:
            logger.info('Query memory size:' + str(memSize))
            return (True, memSize)
        
   
   
    
   
    
   

   
    