# -*- coding: UTF-8 -*-

from common.contextUtil import getLogger

class Log():
    '''
    @summary: log tool class
    '''
    SCRIPT_FLAG = 'pyscript'
    DEFAULT_FORMAT = '[%s] %s'
    
    def __init__(self, context, format=DEFAULT_FORMAT):
        Log.logger = getLogger(context)
        Log.format = format
    
    @staticmethod
    def updateScriptFlag(flag):
        Log.SCRIPT_FLAG = flag
    
    @staticmethod
    def debug(msg):
        Log.logger.debug(Log.format % (Log.SCRIPT_FLAG, msg))
        return
    
    @staticmethod
    def error(msg):
        Log.logger.error(Log.format % (Log.SCRIPT_FLAG, msg))
        return
        
    @staticmethod
    def info(msg):
        Log.logger.info(Log.format % (Log.SCRIPT_FLAG, msg))
        return
    
    @staticmethod
    def warn(msg):
        Log.logger.warn(Log.format % (Log.SCRIPT_FLAG, msg))
        return
