# -*- coding: UTF-8 -*-
from funcFactory.dataCollectUtil import collectData
from common.log import Log
from frame.cli.cliUtil import getProductModel
from common.commonFunction import getTitleFromXmInfo
from frame.context.contextUtil import getItem, initCliConnection, getCli, getLang
from common.constant import PRODUCT_MODEL
from common.result import setResultFail
import traceback
from funcFactory.cliParser import parse_transverseTable


def execute(context):
    try:
        #构造收集项的title
        setTitleData(context)
        #构造收集项的收集数据
        return setRetData(context)
    except Exception, ex:
        Log.error("Failed to execute collectStandard file, because %s" % str(traceback.format_exc()))
        return setResultFail(context, "collect.standard.fail.errMsg")


def setTitleData(context):
    cmd4IBMS = getItem(context, "cmd4IBMS")
    titleListMap = getTitleFromXmInfo(cmd4IBMS)
    context["titleListMap"] = titleListMap
    
    
def setRetData(context):
    cmd4IBMS = getItem(context, "cmd4IBMS")
    (code, retDataMap, allErrMsg) = collectData(context, cmd4IBMS)
    #对cli返回的原始数据进行处理
    resultHandle(context, retDataMap)
    context["retDataMap"] = retDataMap
    return (code, "", allErrMsg)


def resultHandle(context, retDataMap):
    #获取产品型号
    initCliConnection(context)   
    cli = getCli(context)
    lang = getLang(context)
    (isSucess, productModel, errMsg) = getProductModel(cli, lang)
    
    rackLocationList, shelfLocationDict = getRackAndShelfLocation(context)
    
    for oneDataKey in retDataMap:
        if oneDataKey in ["ExpansionModule", "InterfaceModule", "PowerModule"]:
            dataList = retDataMap[oneDataKey]
            #删除Health Status为No Input的电源信息
            if oneDataKey == "PowerModule":
                length = len(dataList)
                for index in range(0, length):
                    dict = dataList[length - (index + 1)]
                    if dict["Health Status"] == "No Input":
                        dataList.remove(dict)

            for oneData in dataList:
                ID = oneData["ID"]
                rack = "-1"
                shelf = ID.split('.')[0]
                safeDate = "rack=-1,shelf=%s" % shelf
                shelfLocation = shelfLocationDict.get(shelf, safeDate)
                subshelf = "-1"
                slotpos = "1"
                slot = ID
                oneData["ID"] = "%s,subshelf=%s,slotpos=%s,slot=%s" % (shelfLocation, subshelf, slotpos, slot)
        if oneDataKey in ["Enclosure"]:
            dataList = retDataMap[oneDataKey]
            for oneData in dataList:
                ID = oneData["ID"]
                safeDate = "rack=-1,shelf=%s" % ID
                shelfLocation = shelfLocationDict.get(ID, safeDate)
                oneData['Location'] = shelfLocation
        if oneDataKey in ["Controller"]:
            dataList = retDataMap[oneDataKey]
            for oneData in dataList:
                Location = oneData["Location"]
                shelf = Location.split('.')[0]
                safeDate = "rack=-1,shelf=%s" % shelf
                shelfLocation = shelfLocationDict.get(shelf, safeDate)
                subshelf = "-1"
                if productModel in PRODUCT_MODEL.U_2:
                    slotpos = "1"
                else:
                    slotpos = "0"
                slot = Location
                oneData['Location'] = "%s,subshelf=%s,slotpos=%s,slot=%s" % (shelfLocation, subshelf, slotpos, slot)
        if oneDataKey in ["BBU"]:
            dataList = retDataMap[oneDataKey]
            for oneData in dataList:
                ID = oneData["ID"]
                shelf = ID.split('.')[0]
                safeDate = "rack=-1,shelf=%s" % shelf
                shelfLocation = shelfLocationDict.get(shelf, safeDate)
                subshelf = "-1"
                if productModel in PRODUCT_MODEL.U_2:
                    slotpos = "1"
                else:
                    slotpos = "0"
                slot = ID
                oneData['ID'] = "%s,subshelf=%s,slotpos=%s,slot=%s" % (shelfLocation, subshelf, slotpos, slot)
        if oneDataKey in ["Disk"]:
            dataList = retDataMap[oneDataKey]
            for oneData in dataList:
                ID = oneData["ID"]
                shelf = ID.split('.')[0]
                safeDate = "rack=-1,shelf=%s" % shelf
                shelfLocation = shelfLocationDict.get(shelf, safeDate)
                subshelf = "-1"
                slotpos = "0"
                slot = ID
                oneData['ID'] = "%s,subshelf=%s,slotpos=%s,slot=%s" % (shelfLocation, subshelf, slotpos, slot)
        if oneDataKey in ["Fan"]:
            dataList = retDataMap[oneDataKey]
            for oneData in dataList:
                ID = oneData["ID"]
                shelf = ID.split('.')[0]
                safeDate = "rack=-1,shelf=%s" % shelf
                shelfLocation = shelfLocationDict.get(shelf, safeDate)
                subshelf = "-1"
                if productModel in PRODUCT_MODEL.U_2 or (ID.split('.')[0]).startswith("DEA"):
                    slotpos = "1"
                else:
                    slotpos = "0"
                slot = ID
                oneData['ID'] = "%s,subshelf=%s,slotpos=%s,slot=%s" % (shelfLocation, subshelf, slotpos, slot)
        #从软件信息中获取一条不为空的数据
        if oneDataKey in ["Software"]:
            dataList = retDataMap[oneDataKey]
            filteResult = None
            if len(dataList) != 0:
                filteResult = dataList[0]
            else:
                filteResult = {"Current Version":"NA", "Type":"NA", "patchVersion":"NA"}
            for oneData in dataList:
                softWareVersion = oneData["Current Version"]
                if softWareVersion != "--" and softWareVersion != "":
                    filteResult = oneData
                    break
            if filteResult == None:
                retDataMap[oneDataKey] = []
            else:
                retDataMap[oneDataKey] = [filteResult]
        #license
        if oneDataKey in ["License"]:
            dataList = retDataMap[oneDataKey]
            if len(dataList) == 0:
                dataMap = {"License SN":"NA", "LICENSE SERVICE AUTH TYPE":"NA"}
                retDataMap[oneDataKey] = [dataMap]
            else:
                for oneData in dataList:
                    LicenseSN = oneData["License SN"]
                    if LicenseSN in ["", "--"]:
                        oneData["License SN"] = "NA"
                    LicenseServiceType = oneData["LICENSE SERVICE AUTH TYPE"]
                    if LicenseServiceType in ["", "--"]:
                        oneData["LICENSE SERVICE AUTH TYPE"] = "NA"
        #Rack
        if oneDataKey in ["Rack"]:
            rackList = []
            for rackLocation in rackLocationList:
                rackList.append({"Location":rackLocation})
            if len(rackLocationList) == 0:
                 rackList.append({"Location":"rack=-1"})
            retDataMap[oneDataKey] = rackList
        #Dimension
        if oneDataKey in ["Dimension"]:
            enclTypeNumDict = {}
            dataList = retDataMap[oneDataKey]
            #统计不同逻辑类型的框的数量
            for oneData in dataList:
                logicType = oneData["Logic Type"]
                enclTypeNumDict[logicType] = enclTypeNumDict.get(logicType, 0) + 1
            #设置量纲信息
            dataList = []
            for logicType in enclTypeNumDict:
                dimensionDict = {}       
                dimensionDict['Type'] = logicType       
                dimensionDict['Num'] = str(enclTypeNumDict.get(logicType))
                dataList.append(dimensionDict)
                retDataMap[oneDataKey] = dataList
    
    #删除无效的数据（为空或--）
    removeInvalidData(retDataMap)
    
    return
            
    
def removeInvalidData(retDataMap):
    #删除无效的数据（为空或--）
    for oneDataKey in retDataMap:
        dataList = retDataMap[oneDataKey]
        newDataList = []
        for oneData in dataList:
            newOneData = {}
            for cliKey in oneData:
                cliValue = oneData[cliKey]
                if cliValue not in ["", "--"]:
                    newOneData[cliKey] = cliValue      
            newDataList.append(newOneData)
        retDataMap[oneDataKey] = newDataList
        
    return

def getRackAndShelfLocation(context):
    
    rackLocationList = []
    shelfLocationDict = {}
    
    command = "show enclosure |filterColumn include columnList=ID,Location"
    (isSuccess, dictList, cliRet, errMsg) = parse_transverseTable(context, command)

    for dict in dictList:
        shelfID = dict.get("ID")
        rackLocation = dict.get("Location")
        if rackLocation not in ["--", ""]:
            rackLocation = "rack=%s" % rackLocation.split(".")[0]
            if rackLocationList.count(rackLocation) == 0:
                rackLocationList.append(rackLocation)
            shelfLocation = "%s,shelf=%s" % (rackLocation, shelfID)
            shelfLocationDict.setdefault(shelfID, shelfLocation)
        else:
            if rackLocationList.count("rack=-1") == 0:
                rackLocationList.append("rack=-1")
            shelfLocation = "rack=-1,shelf=%s" % shelfID
            shelfLocationDict.setdefault(shelfID, shelfLocation)
        
    return (rackLocationList, shelfLocationDict)
            
            
    
    


