# -*- coding: UTF-8 -*-
from frame.cli.cliUtil import getHorizontalCliRet, getVerticalCliRet,getVerticalCliRetForLicense, getSplitedCliRet, getMsg, getHorizontalCliRetFilterElabel, getHorizontalNostandardCliRet
from common.log import Log
from common.commonFunction import excuteCmd, excuteCmdInDeveloper, getHorizontalCliTiltle, getVerticalCliTiltle

     
def logWhenCliExcuteFailed(command, errMsg, cliRet):
    Log.error("execute cli %s failed, because %s, and the cli return is %s" % (command, errMsg, cliRet))
    return


def setTitleListInCliRet(context, cliRet, cliType, collectItemName):
    '''
    @summary: 从CLI回显中获取title，并将其放入context中
    '''
    collectItemTitleListInContext = []
    titleListMap = context["titleListMap"]
    if collectItemName != None: 
        collectItemTitleListInContext = titleListMap[collectItemName]
        
    if cliType in ["transverseTable", "transverseTableInDeveloper", "filterCliNoParseElcLabel", "filterCli", "diskNoParseElcLabel"]:
        collectItemTitleListInContext = getHorizontalCliTiltle(cliRet)
 
    if cliType in ["verticalTable", "verticalTableNoParseElcLabel", "verticalTableInDeveloper"]:
        collectItemTitleListInContext = getVerticalCliTiltle(cliRet)

    if len(collectItemTitleListInContext) != 0:
        titleListMap[collectItemName] = collectItemTitleListInContext
    return


def getInfoByCliParser(context, command, cliType, collectItemTitleList, collectItemName = None):
    '''
    @summary: 调用cli解析器获取cli回显，并过滤出collectItemTitleList中的内容
    @param command: cli命令
    @param cliType: cli命令回显结构
    @param collectItemTitleList: 获取的cli回显的字典
    @return: (cli命令，cli类型，需要获取的回显字段)
    '''
    cliParserName = "parse_%s" % cliType
    cliParser = globals()[cliParserName]
    #根据cmd4IBMS.xml<cmd><baseCmd>节点中配置的cli命令自动调用cliParser.py中的同名方法来收集数据
    (isSuccess, dictList, cliRet, errMsg) = cliParser(context, command)
    
    if (len(collectItemTitleList) == 1 and collectItemTitleList[0] == "AllItem"):
        setTitleListInCliRet(context, cliRet, cliType, collectItemName)
        return (isSuccess, dictList, cliRet, errMsg)
    
    else:
        if not isSuccess or dictList == None:
            return (isSuccess, dictList, cliRet, errMsg)       
        #根据cmd4IBMS.xml<str>节点中配置的收集数据从cli回显中筛选出最终的数据
        dictList = retDataFilter(dictList, collectItemTitleList)
        return (isSuccess, dictList, cliRet, errMsg)


def retDataFilter(allData, filtData):
    '''
    @summary: 筛选完整的cli回显中包含在<attr>节点中的数据
    @param allData: cli回显(一个字典列表)
    @param filtData: <attr>节点中配置的收集数据
    @return: 收集项的数据（一个字典列表）
    ''' 
    for oneData in allData:
        oneDataKeys = oneData.keys()
        for key in oneDataKeys:
            if key not in filtData:
                oneData.pop(key)
                
    return allData


def parse_verticalTable(context, command):
    '''
    @summary: 执行cli命令并将回显解析成[{},{},...]，此种cli回显为竖向列表
    @param command: cli命令
    @return: (cli执行是否成功，cli回显解析后的列表，cli执行失败时的原因)
    '''
    (isSuccess, cliRet, errMsg) = excuteCmd(context, command)
    if not isSuccess:
        logWhenCliExcuteFailed(command, errMsg, cliRet)
        return (isSuccess, None, cliRet, errMsg)
    
    #将cli回显解析为字典列
    dictList = getVerticalCliRet(cliRet)
    #cli执行成功，但cli解析为空，即cli未获取到信息
    if len(dictList) == 0:
        dictList = None
    return (isSuccess, dictList, cliRet, errMsg)


def parse_transverseTable(context, command):
    '''
    @summary: 执行cli命令并将回显解析成[{},{},...]，此种cli回显为横向列表
    @param command: cli命令
    @return: (cli执行是否成功，cli回显解析后的列表，cli执行失败时的原因)
    '''
    (isSuccess, cliRet, errMsg) = excuteCmd(context, command)
    if not isSuccess:
        logWhenCliExcuteFailed(command, errMsg, cliRet)
        return (isSuccess, None, cliRet, errMsg)
    
    #将cli回显解析为字典列
    dictList = getHorizontalCliRet(cliRet)
    #cli执行成功，但cli解析为空，即cli未获取到信息
    if len(dictList) == 0:
        dictList = None
    return (isSuccess, dictList, cliRet, errMsg)

    
def parse_mixTable(context, command):
    '''
    @summary: 执行cli命令并将回显解析成[{},{},...]，此种cli回显为多个“----“分隔的竖向表格
                                    但第一个表格与其它表格字段不一致，此方法用来获取其中第一个表格的内容
    @param command: cli命令
    @return: (cli执行是否成功，cli回显解析后的列表，cli执行失败时的原因)
    '''
    (isSuccess, cliRet, errMsg) = excuteCmd(context, command)
    if not isSuccess:
        logWhenCliExcuteFailed(command, errMsg, cliRet)
        return (isSuccess, None, cliRet, errMsg)
    
    #将cli回显解析为字典列
    dictList = getVerticalCliRet(cliRet)

    #cli执行成功，但cli解析为空，即cli未获取到信息
    if len(dictList) == 0:
        dictList = None
    else:
        dictList = [dictList[0]]
    return (isSuccess, dictList, cliRet, errMsg)


def parse_softWare(context, command):
    '''
    @summary: 执行show upgrade package,获取其中的部分内容
    @param command: cli命令
    @return: (cli执行是否成功，cli回显解析后的列表，cli执行失败时的原因)
    '''
    (isSuccess, cliRet, errMsg) = excuteCmd(context, command)
    if not isSuccess:
        logWhenCliExcuteFailed(command, errMsg, cliRet)
        return (isSuccess, None, cliRet, errMsg)
    
    hotPatchVersionIndex = cliRet.find("HotPatch Version")
    
    softwareVersion = getSplitedCliRet(cliRet[:hotPatchVersionIndex], "Software Version")
    softwareVersionList = getHorizontalCliRet(softwareVersion)
    
    hotPatchVersion = getSplitedCliRet(cliRet[hotPatchVersionIndex:], "HotPatch Version")
    hotPatchVersionList = getHorizontalCliRet(hotPatchVersion)
    
    for softVersion in softwareVersionList:
        for hotPatchVersion in hotPatchVersionList: 
            if softVersion["Name"] == hotPatchVersion["Name"]:
                softVersion["patchVersion"] = hotPatchVersion["Current Version"]
    
    return (isSuccess, softwareVersionList, cliRet, errMsg)


def parse_verticalTableNoParseElcLabel(context, command):
    '''
    @summary: 解析竖向列表结构的CLI回显,其中电子标签作为一个整体,不再解析
    @param allData: cli回显(一个字典列表)
    @param filtData: <attr>节点中配置的收集数据
    @return: 收集项的数据（一个字典列表）
    '''
    (isSuccess, cliRet, errMsg) = excuteCmd(context, command)
    if not isSuccess:
        logWhenCliExcuteFailed(command, errMsg, cliRet)
        return (isSuccess, None, cliRet, errMsg)
    
    #将cli回显解析为字典列
    isParseElcLabel = False
    dictList = getVerticalCliRet(cliRet, isParseElcLabel)
    #cli执行成功，但cli解析为空，即cli未获取到信息
    if len(dictList) == 0:
        dictList = None
    return (isSuccess, dictList, cliRet, errMsg)


def parse_verticalTableInDeveloper(context, command):
    '''
    @summary: 解析竖向列表结构的developer命令回显
    @param allData: cli回显(一个字典列表)
    @param filtData: <attr>节点中配置的收集数据
    @return: 收集项的数据（一个字典列表）
    '''
    (isSuccess, cliRet, errMsg) = excuteCmdInDeveloper(context, command)
    if not isSuccess:
        logWhenCliExcuteFailed(command, errMsg, cliRet)
        return (isSuccess, None, cliRet, errMsg)
    
    #将cli回显解析为字典列
    dictList = getVerticalCliRet(cliRet)
    #cli执行成功，但cli解析为空，即cli未获取到信息
    if len(dictList) == 0:
        dictList = None
    return (isSuccess, dictList, cliRet, errMsg)


def parse_transverseTableInDeveloper(context, command):
    '''
    @summary: 解析横向列表结构的developer命令回显
    @param allData: cli回显(一个字典列表)
    @param filtData: <attr>节点中配置的收集数据
    @return: 收集项的数据（一个字典列表）
    '''
    (isSuccess, cliRet, errMsg) = excuteCmdInDeveloper(context, command)
    if not isSuccess:
        logWhenCliExcuteFailed(command, errMsg, cliRet)
        return (isSuccess, None, cliRet, errMsg)
    
    #将cli回显解析为字典列
    dictList = getHorizontalCliRet(cliRet)
    #cli执行成功，但cli解析为空，即cli未获取到信息
    if len(dictList) == 0:
        dictList = None
    return (isSuccess, dictList, cliRet, errMsg)
   
    
def getLicenseOrFeatureCliRet(context, command, isLicenseFeature):
    '''
    @summary: 解析show license命令回显，并将其解析为license基本信息，license特性两个字典列表
    @param allData: cli回显(一个字典列表)
    @param filtData: <attr>节点中配置的收集数据
    @return: 收集项的数据（一个字典列表）
    '''
    (isSuccess, cliRet, errMsg) = excuteCmd(context, command)
    if not isSuccess:
        logWhenCliExcuteFailed(command, errMsg, cliRet)
        return (isSuccess, None, cliRet, errMsg)
    
    #适配license 功能项信息和资源项信息同时存在情况
    Index = "Maximal Resource Number"
    if Index in cliRet:
        regionIndex  = cliRet.rindex(Index)
    else:
        regionIndex = cliRet.find("Region")
        
    featureIndex  = cliRet.find("Feature Name")
    
    licenseOrFeatureCliRet = ""
    if isLicenseFeature:
        licenseOrFeatureCliRet = cliRet[(regionIndex):]
        dictList = getVerticalCliRet(licenseOrFeatureCliRet)
        Log.info("FeatureCliRet %s" % licenseOrFeatureCliRet)
    else:
        licenseOrFeatureCliRet = cliRet[:(featureIndex)]
    #将cli回显解析为字典列
        dictList = getVerticalCliRetForLicense(licenseOrFeatureCliRet)
    #cli执行成功，但cli解析为空，即cli未获取到信息
    if len(dictList) == 0:
        dictList = None
    return (isSuccess, dictList, cliRet, errMsg)


def parse_License(context, command):
    '''
    @summary: 执行show license命令回显，并将回显的上部解析为license的基本信息
    '''
    isLicenseFeature = False
    return getLicenseOrFeatureCliRet(context, command, isLicenseFeature)


def parse_LicenseFeature(context, command):
    '''
    @summary: 执行show license命令回显，并将回显的下部部解析为license特性的基本信息
    '''
    isLicenseFeature = True
    return getLicenseOrFeatureCliRet(context, command, isLicenseFeature)

def parse_securityRule(context, command):
    '''
    @summary: 执行show security_rule命令回显，将Enabled与Secure IP Address的回显放到同一个字典列表中
    '''
    dictList = []
    
    (isSuccess, cliRet, errMsg) = excuteCmd(context, command)
    if not isSuccess:
        logWhenCliExcuteFailed(command, errMsg, cliRet)
        return (isSuccess, None, cliRet, errMsg)
    
    enabledCliRet = ""
    ipCliRet = ""
    
    idIndex = cliRet.find("  ID")
    if idIndex < 0:
        enabledCliRet = cliRet
    else:
        enabledCliRet = cliRet[:idIndex]
        ipCliRet = cliRet[idIndex:]
    
    enableDictList = []
    if enabledCliRet != "":
        enableDictList = getHorizontalCliRet(enabledCliRet)
    
    for enableDict in enableDictList:
        if enableDict["Enabled"] == "":
            continue
        enableDict["ID"] = ""
        enableDict["Secure IP Address"] = ""
        dictList.append(enableDict)
    
    ipDictList = []
    if ipCliRet != "":
        ipDictList = getHorizontalCliRet(ipCliRet)
        
    for ipDict in ipDictList:
        if ipDict["ID"] == "" and ipDict["Secure IP Address"] == "":
            continue
        ipDict["Enabled"] = ""
        dictList.append(ipDict)
        
    #cli执行成功，但cli解析为空，即cli未获取到信息
    if len(dictList) == 0:
        dictList = None
        
    return (isSuccess, dictList, cliRet, errMsg)

def parse_upgradePackage(context, command):
    '''
    @summary: 执行show upgrade packge命令回显，将Software Version与HotPatch Version的
              回显存放到同一个字典列表中，并增加Version Type键来区分Version类型
    '''
    dictList = []
    (isSuccess, cliRet, errMsg) = excuteCmd(context, command)
    if not isSuccess:
        logWhenCliExcuteFailed(command, errMsg, cliRet)
        return (isSuccess, None, cliRet, errMsg)
    
    softwareVersionIndex = cliRet.find("Software Version")
    hotPatchVersionIndex = cliRet.find("HotPatch Version")
    softwareVersionList = getHorizontalCliRet(cliRet[(softwareVersionIndex):hotPatchVersionIndex])
    hotPatchVersionList = getHorizontalCliRet(cliRet[(hotPatchVersionIndex):])
    Log.info("softwareVersionList list is %s" % str(softwareVersionList))
    Log.info("hotPatchVersionList list is %s" % str(hotPatchVersionList))
    
    if len(softwareVersionList) == 0 or len(hotPatchVersionList) == 0:
        dictList = None
        return (isSuccess, dictList, cliRet, errMsg)
    
    for softwareVersion in softwareVersionList:
        softwareVersion["Version Type"] = "Software Version"
    
    for hotPatchVersion in hotPatchVersionList:
        hotPatchVersion["Version Type"] = "HotPatch Version"
    
    Log.info("softwareVersionList2 list is %s" % str(softwareVersionList))
    Log.info("hotPatchVersionList2 list is %s" % str(hotPatchVersionList))
        
    softwareVersionList.extend(hotPatchVersionList)
    dictList= softwareVersionList
    Log.info("upgradePackage list is %s" % str(dictList))
    
    return (isSuccess, dictList, cliRet, errMsg)
    
    
def getVersionCliRet(context, command, versionType):
    '''
    @summary: 执行show version all命令回显，并根据versionType解析不同类型的version
    '''
    (isSuccess, cliRet, errMsg) = excuteCmd(context, command)
    if not isSuccess:
        logWhenCliExcuteFailed(command, errMsg, cliRet)
        return (isSuccess, None, cliRet, errMsg)
    
    controllerVersionIndex  = cliRet.find("Controller:")
    expansionVersionIndex  = cliRet.find("Expansion Module:")
    bbuVersionIndex  = cliRet.find("BBU:")
    
    versionCliRet = ""
    dictList = []
    if versionType == "productVersion":
        versionCliRet = cliRet[:controllerVersionIndex]
        dictList = getVerticalCliRet(versionCliRet)
    if versionType == "controllerVersion":
        versionCliRet = cliRet[(controllerVersionIndex):expansionVersionIndex]
        dictList = getVerticalCliRet(versionCliRet)
    if versionType == "expansionVersion":
        versionCliRet = cliRet[(expansionVersionIndex):bbuVersionIndex]
        dictList = getHorizontalCliRet(versionCliRet)
    if versionType == "bbuVersion":
        versionCliRet = cliRet[(bbuVersionIndex):]
        dictList = getHorizontalCliRet(versionCliRet)
    
    #cli执行成功，但cli解析为空，即cli未获取到信息
    if len(dictList) == 0:
        dictList = None
    return (isSuccess, dictList, cliRet, errMsg)


def parse_productVersion(context, command):
    '''
    @summary: 执行show version all命令回显，获取product Version
    '''
    versionType = "productVersion"
    return getVersionCliRet(context, command, versionType)


def parse_controllerVersion(context, command):
    '''
    @summary: 执行show version all命令回显，controller Version
    '''
    versionType = "controllerVersion"
    return getVersionCliRet(context, command, versionType)


def parse_expansionVersion(context, command):
    '''
    @summary: 执行show version all命令回显，expansion Version
    '''
    versionType = "expansionVersion"
    return getVersionCliRet(context, command, versionType)


def parse_bbuVersion(context, command):
    '''
    @summary: 执行show version all命令回显，bbu Version
    '''
    versionType = "bbuVersion"
    return getVersionCliRet(context, command, versionType)


def parse_filterCliNoParseElcLabel(context, command):
    '''
    @summary: 执行cli命令并将回显解析成[{},{},...]，此种cli回显为竖向列表
    @param command: cli命令
    @return: (cli执行是否成功，cli回显解析后的列表，cli执行失败时的原因)
    '''
    (isSuccess, cliRet, errMsg) = excuteCmd(context, command)
    if not isSuccess:
        logWhenCliExcuteFailed(command, errMsg, cliRet)
        return (isSuccess, None, cliRet, errMsg)
    
    #将cli回显解析为字典列
    dictList = getHorizontalCliRetFilterElabel(cliRet, False)
    #cli执行成功，但cli解析为空，即cli未获取到信息
    if len(dictList) == 0:
        dictList = None
    return (isSuccess, dictList, cliRet, errMsg)


def parse_filterCli(context, command):
    '''
    @summary: 执行cli命令并将回显解析成[{},{},...]，此种cli回显为竖向列表
    @param command: cli命令
    @return: (cli执行是否成功，cli回显解析后的列表，cli执行失败时的原因)
    '''
    (isSuccess, cliRet, errMsg) = excuteCmd(context, command)
    if not isSuccess:
        logWhenCliExcuteFailed(command, errMsg, cliRet)
        return (isSuccess, None, cliRet, errMsg)
    
    #将cli回显解析为字典列
    dictList = getHorizontalCliRetFilterElabel(cliRet)
    #cli执行成功，但cli解析为空，即cli未获取到信息
    if len(dictList) == 0:
        dictList = None
    return (isSuccess, dictList, cliRet, errMsg)


def parse_disk(context, command):
    '''
    @summary: 硬盘信息收集特殊处理，因为830上网版本与SPC300所用CLI不一样
    '''
    (isSuccess, cliRet, errMsg) = excuteCmd(context, command)
    if isExistCmdForRec(cliRet):
        return parse_filterCli(context, command)
    else:
        command = "show disk general|filterColumn include columnList=ID,Type,Model,Firmware\sVersion,Manufacturer,Bar\sCode"
        return parse_transverseTable(context, command)


def parse_diskNoParseElcLabel(context, command):
    '''
    @summary: 硬盘信息收集特殊处理，因为830上网版本与SPC300所用CLI不一样
    '''
    (isSuccess, cliRet, errMsg) = excuteCmd(context, command)
    if isExistCmdForRec(cliRet):
        return parse_filterCliNoParseElcLabel(context, command)
    else:
        command = "show disk general|filterColumn include columnList=ID,Health\sStatus,Running\sStatus,Type,Capacity,Role,Disk\sDomain\sID,Speed(RPM),Health\sMark,Model,Firmware\sVersion,Manufacturer,Serial\sNumber,Bar\sCode"
        return parse_transverseTable(context, command)


def isExistCmdForRec(cliRet):
    '''
    @summary: 根据命令回显信息，判断当前命令是否在系统中存在
            判断标准：若在回显中出现 '^'符号，则当前命令不存在
    '''
    if  cliRet is None or cliRet == "":
        return False
        
    if "^" in cliRet:
        return False
        
    return True


def parse_nostandardtransverseTable(context, command):
    '''       
    @summary: 执行cli命令并将回显解析成[{},{},...]，此种cli回显为横向列表，此为下发CLI命令回显不对齐时情况
    @param command: cli命令
    @return: (cli执行是否成功，cli回显解析后的列表，cli执行失败时的原因)
    '''
    (isSuccess, cliRet, errMsg) = excuteCmd(context, command)
    if not isSuccess:
        logWhenCliExcuteFailed(command, errMsg, cliRet)
        return (isSuccess, None, cliRet, errMsg)
    
    #将cli回显解析为字典列
    dictList = getHorizontalNostandardCliRet(cliRet)
    Log.info("cliRet is %s" % cliRet)
    Log.info("dictList is %s" % dictList)
    #cli执行成功，但cli解析为空，即cli未获取到信息
    if len(dictList) == 0:
        dictList = None
    return (isSuccess, dictList, cliRet, errMsg)