# -*- coding: UTF-8 -*-
from funcFactory.dataCollectUtil import collectData
from common.log import Log
from common.commonFunction import getTitleFromXmInfo
from frame.context.contextUtil import getItem
from common.result import setResultFail
import traceback


def execute(context):
    try:
        #构造收集项的title
        setTitleData(context)
        #构造收集项的收集数据
        return setRetData(context)
    except Exception, ex:
        Log.error("Failed to execute collectExtend file, because %s" % str(traceback.format_exc()))
        return setResultFail(context, "collect.extend.fail.errMsg")


def setTitleData(context):
    cmd4Excel = getItem(context, "cmd4Excel")
    titleListMap = getTitleFromXmInfo(cmd4Excel)
    context["titleListMap"] = titleListMap
    
    
def setRetData(context):
    cmd4Excel = getItem(context, "cmd4Excel")
    (code, retDataMap, allErrMsg) = collectData(context, cmd4Excel)
    context["retDataMap"] = retDataMap
    titleListHandle(context)
    return (code, "", allErrMsg)
            
        
def titleListHandle(context):
    '''
    @summary: 将未获取到数据的收集项的title置空
    '''
    titleListMap = context["titleListMap"]
    retDataMap = context["retDataMap"]
    for oneDataKey in retDataMap:
        if len(retDataMap[oneDataKey]) == 0:
            titleListMap[oneDataKey] = []
    return
            
    


