# -*- coding: UTF-8 -*-
from common.commonFunction import checkSystemNormal,checkUserPrivilege,isExistCmdForRec,downloadFile
from frame.context.contextUtil import  getCli, getLang ,getSftp
from common.constant import CONFIG
from common.result import setResultFail,setResultSucc
import traceback
from common.log import Log
from common.commonFunction import excuteCmd


def execute(context):
    try:
        #收集前检查
        #检查系统是否正常
        isSysNormal ,errMsg = checkSystemNormal(context)
        if not isSysNormal:
            return False ,errMsg
        
        #检查用户级别是否满足收集信息
        isPrivilege ,errMsg = checkUserPrivilege(context)
        if not isPrivilege:
            return False , errMsg
               
        
        #执行收集Config.TXT文件的业务流程
        tempCmd = "show file export_path file_type=%s" % (CONFIG.EXPORT_TYPE_RUNNING_DATA)
        Log.info("execute collect : %s" % str(tempCmd))
        isSuccess,cliRet ,errMeg = excuteCmd(context,tempCmd)
        if not isSuccess:
            return False ,errMeg   
        
        existCmd = isExistCmdForRec(cliRet)
        if not existCmd:
        #命令不存在，表示环境版本过低，直接收集成功
            Log.info("commend not exist %s" % str(cliRet))
            return True ,""
        
        #下载文件
        loadSucc = downloadFile(context, CONFIG.EXPORT_TYPE_RUNNING_DATA, cliRet)
        if not loadSucc:
            return setResultFail(context,"downLoad.file.failure")
            Log.info( "download file failed, and delete file")
                
        
        return setResultSucc()
                
    except Exception:
        Log.error("Failed to execute collectStandard file, because %s" % str(traceback.format_exc()))
        return setResultFail(context, "collect.fail.msg.runningdata")
    
    
    