# -*- coding: UTF-8 -*-
from funcFactory.dataCollectUtil import collectData
from common.log import Log
from frame.cli.cliUtil import getProductModel
from common.commonFunction import getTitleFromXmInfo
from frame.context.contextUtil import getItem, initCliConnection, getCli, getLang
from common.constant import PRODUCT_MODEL
from common.result import setResultFail
import traceback


def execute(context):
    try:
        #构造收集项的title
        setTitleData(context)
        #构造收集项的收集数据
        return setRetData(context)
    except Exception, ex:
        Log.error("Failed to execute collectStandard file, because %s" % str(traceback.format_exc()))
        return setResultFail(context, "collect.standard.fail.errMsg")


def setTitleData(context):
    cmd4IBMS = getItem(context, "cmd4IBMS")
    titleListMap = getTitleFromXmInfo(cmd4IBMS)
    context["titleListMap"] = titleListMap
    
    
def setRetData(context):
    cmd4IBMS = getItem(context, "cmd4IBMS")
    (code, retDataMap, allErrMsg) = collectData(context, cmd4IBMS)
    #对cli返回的原始数据进行处理
    resultHandle(context, retDataMap)
    context["retDataMap"] = retDataMap
    return (code, "", allErrMsg)


def resultHandle(context, retDataMap):
    #获取产品型号
    initCliConnection(context)   
    cli = getCli(context)
    lang = getLang(context)
    (isSucess, productModel, errMsg) = getProductModel(cli, lang)
    
    for oneDataKey in retDataMap:
        if oneDataKey in ["ExpansionModule", "InterfaceModule", "PowerModule"]:
            dataList = retDataMap[oneDataKey]
            #删除Health Status为No Input的电源信息
            if oneDataKey == "PowerModule":
                length = len(dataList)
                for index in range(0, length):
                    dict = dataList[length - (index + 1)]
                    if dict["Health Status"] == "No Input":
                        dataList.remove(dict)

            for oneData in dataList:
                ID = oneData["ID"]
                rack = "-1"
                shelf = ID.split('.')[0]
                subshelf = "-1"
                slotpos = "1"
                slot = ID
                oneData["ID"] = "rack=%s,shelf=%s,subshelf=%s,slotpos=%s,slot=%s" % \
                (rack, shelf, subshelf, slotpos, slot)
        if oneDataKey in ["Enclosure"]:
            dataList = retDataMap[oneDataKey]
            for oneData in dataList:
                ID = oneData["ID"]
                Location = oneData["Location"]
                if len(Location.split('.')) > 1:
                    rack = Location.split('.')[0]
                else:
                    rack = "-1"
                shelf = ID
                oneData['Location'] = "rack=%s,shelf=%s" % (rack, shelf)
        if oneDataKey in ["Controller"]:
            dataList = retDataMap[oneDataKey]
            for oneData in dataList:
                Location = oneData["Location"]
                rack = "-1"
                shelf = Location.split('.')[0]
                subshelf = "-1"
                if productModel in PRODUCT_MODEL.U_2:
                    slotpos = "1"
                else:
                    slotpos = "0"
                slot = Location
                oneData['Location'] = "rack=%s,shelf=%s,subshelf=%s,slotpos=%s,slot=%s" % \
                (rack, shelf, subshelf, slotpos, slot)
        if oneDataKey in ["BBU"]:
            dataList = retDataMap[oneDataKey]
            for oneData in dataList:
                ID = oneData["ID"]
                rack = "-1"
                shelf = ID.split('.')[0]
                subshelf = "-1"
                if productModel in PRODUCT_MODEL.U_2:
                    slotpos = "1"
                else:
                    slotpos = "0"
                slot = ID
                oneData['ID'] = "rack=%s,shelf=%s,subshelf=%s,slotpos=%s,slot=%s" % \
                (rack, shelf, subshelf, slotpos, slot)
        if oneDataKey in ["Disk"]:
            dataList = retDataMap[oneDataKey]
            for oneData in dataList:
                ID = oneData["ID"]
                rack = "-1"
                shelf = ID.split('.')[0]
                subshelf = "-1"
                slotpos = "0"
                slot = ID
                oneData['ID'] = "rack=%s,shelf=%s,subshelf=%s,slotpos=%s,slot=%s" % \
                (rack, shelf, subshelf, slotpos, slot)
        if oneDataKey in ["Fan"]:
            dataList = retDataMap[oneDataKey]
            for oneData in dataList:
                ID = oneData["ID"]
                rack = "-1"
                shelf = ID.split('.')[0]
                subshelf = "-1"
                if productModel in PRODUCT_MODEL.U_2 or (ID.split('.')[0]).startswith("DEA"):
                    slotpos = "1"
                else:
                    slotpos = "0"
                slot = ID
                oneData['ID'] = "rack=%s,shelf=%s,subshelf=%s,slotpos=%s,slot=%s" % \
                (rack, shelf, subshelf, slotpos, slot)
        #从软件信息中获取一条不为空的数据
        if oneDataKey in ["Software"]:
            dataList = retDataMap[oneDataKey]
            filteResult = None
            if len(dataList) != 0:
                filteResult = dataList[0]
            else:
                filteResult = {"Current Version":"NA", "Type":"NA", "patchVersion":"NA"}
            for oneData in dataList:
                softWareVersion = oneData["Current Version"]
                if softWareVersion != "--" and softWareVersion != "":
                    filteResult = oneData
                    break
            if filteResult == None:
                retDataMap[oneDataKey] = []
            else:
                retDataMap[oneDataKey] = [filteResult]
        #license
        if oneDataKey in ["License"]:
            dataList = retDataMap[oneDataKey]
            if len(dataList) == 0:
                dataMap = {"License SN":"NA", "LICENSE SERVICE AUTH TYPE":"NA"}
                retDataMap[oneDataKey] = [dataMap]
            else:
                for oneData in dataList:
                    LicenseSN = oneData["License SN"]
                    if LicenseSN in ["", "--"]:
                        oneData["License SN"] = "NA"
                    LicenseServiceType = oneData["LICENSE SERVICE AUTH TYPE"]
                    if LicenseServiceType in ["", "--"]:
                        oneData["LICENSE SERVICE AUTH TYPE"] = "NA"
        #Rack
        if oneDataKey in ["Rack"]:
            rackList = []
            locationList = []
            dataList = retDataMap[oneDataKey]
            for oneData in dataList:
                Location = oneData["Location"]
                if Location not in ["", "--"]:
                    location = Location.split(".")[0]
                    if locationList.count(location) == 0:
                        locationList.append(location)
                        rackList.append({"Location":location})
            #未查询到柜信息则设置默认值              
            if len(rackList) == 0:
                rackList.append({"Location":"rack=-1"})
            retDataMap[oneDataKey] = rackList
        #Dimension
        if oneDataKey in ["Dimension"]:
            enclTypeNumDict = {}
            dataList = retDataMap[oneDataKey]
            #统计不同逻辑类型的框的数量
            for oneData in dataList:
                logicType = oneData["Logic Type"]
                enclTypeNumDict[logicType] = enclTypeNumDict.get(logicType, 0) + 1
            #设置量纲信息
            dataList = []
            for logicType in enclTypeNumDict:
                dimensionDict = {}       
                dimensionDict['Type'] = logicType       
                dimensionDict['Num'] = str(enclTypeNumDict.get(logicType))
                dataList.append(dimensionDict)
                retDataMap[oneDataKey] = dataList
    
    #删除无效的数据（为空或--）
    removeInvalidData(retDataMap)
    
    return
            
    
def removeInvalidData(retDataMap):
    #删除无效的数据（为空或--）
    for oneDataKey in retDataMap:
        dataList = retDataMap[oneDataKey]
        newDataList = []
        for oneData in dataList:
            newOneData = {}
            for cliKey in oneData:
                cliValue = oneData[cliKey]
                if cliValue not in ["", "--"]:
                    newOneData[cliKey] = cliValue      
            newDataList.append(newOneData)
        retDataMap[oneDataKey] = newDataList
        
    return


