# -*- coding: UTF-8 -*-
from defusedxml import ElementTree as ET


def parseXMLFile(filePath):
    '''
    @summary: 解析xml文件
    @param filePath: xml文件路径
    @return: 解析后的xml文件信息（一个嵌套的字典)
    '''
    xmlElementTree = ET.parse(filePath)
    rootElement = xmlElementTree.getroot()
    #通过解析xml文件的根节点来解析整个文件
    xmlInfo = parseXMLElement(rootElement)
    return xmlInfo

  
def parseXMLElement(element):
    '''
    @summary: 解析xml的一个节点
    @param element: xml的一个节点
    @return: 解析后的xml节点信息（一个嵌套的字典)
    '''
    elementName = element.tag
    elementAttrbutes = element.attrib
    if element.text == None:
        element.text = ""
    elementText = element.text.strip()
    
    #对节点的子节点
    elementChildEles = []
    childElements = element.getchildren()
    for childElement in childElements:
        elementChildEles.append(parseXMLElement(childElement))
    
    #将xml节点的名称，属，文本，子节点存放到字典
    elementInfo = {    
                   "elementName":elementName,
                   "elementAttrbutes":elementAttrbutes,
                   "elementText":str(elementText),
                   "elementChildEles":elementChildEles       
                   }  
    
    return elementInfo

