# -*- coding: UTF-8 -*-
from common.log import Log
from common.xmlParser import parseXMLFile
from common.result import setResultFail, setResultSucc
from common.commonFunction import excuteCmd
from common.constant import CMD
from frame.context.contextUtil import setItem, getCli, getLang, getConnectorFactoryObj, getDevObj
from frame.cli.cliUtil import getVerticalCliRet, get_internal_product_model
from frame.cli.cliUtil import getProductVersion, getMsg,getHorizontalCliRet
import traceback
import os
import re
from com.huawei.ism.tool.obase.exception import PwdException
from common.constant import SCRIPT_RET_CODE
from common.commonFunction import getModelVersion
from common.constant import COLLECT_CONFIG
from cbb.frame.base import config



def execute(context):
    '''
    @summary: 框架默认入口函数
    '''
    try:
        initLog(context)
        
        #检查用户是否为备份管理员（部分管理员进行限制收集）
        loginUserName = context.get("dev").getLoginUser().getUserName()
        Log.info("loginUserName is %s" % str(loginUserName))
        isPass = checkLoginAdministrator(context,loginUserName)
        if not isPass:
            return setResultFail(context, "loginUser.name.level.check.failure")
        
        #检查用户名称是否非法（部分关键字作为用户名将影响CLI执行结果判断）
        isPass = checkLoginUserName(loginUserName)
        if not isPass:
            return setResultFail(context, "loginUser.name.check.failure")
        
        isPass, errMsg = checkConnection(context)
        if not isPass:
            return (SCRIPT_RET_CODE.FAIL, errMsg)
           
        if not canExecCliCmd(context):
            return setResultFail(context, "systemStatus.abmormal.errMsg")
            
        #解析标准收集项和扩展收集项的配置文件
        flag, productModel_version, errMsg = getModelVersion(context)
        if flag == False:
            return (SCRIPT_RET_CODE.FAIL, errMsg)

        IBMSFileName = get_ibms_file_name(context, productModel_version)

        ExcelFileName = "cmd4Excel.xml"
        regx_v3 = re.compile(r"^Dorado\d+.* V\d+ V\d{3}R\d{3}C\d{2}.*")
        regx_v6 = re.compile(r"^OceanStor Dorado .* V\d+ [\d+.*]+.*")
        if regx_v3.findall(productModel_version):
            ExcelFileName = COLLECT_CONFIG.DORADO_V3_EXCEL
        elif regx_v6.findall(productModel_version):
            ExcelFileName = COLLECT_CONFIG.DORADO_V6_EXCEL
        Log.info("IBMS File Name is %s" % IBMSFileName)
        Log.info("Excel File Name is %s" % ExcelFileName)
        
        (isSuccess, cmd4IBMSxmlInfo) = parseCmd4IBMSxmlFile(context, IBMSFileName)
        (isSuccess, cmd4ExcelxmlInfo) = parseCmd4ExcelxmlFile(context, ExcelFileName)
        
        if not isSuccess:
            return setResultFail(context, "parse.xml.cmdxml.fail.errMsg")
        else:
            setItem(context, "cmd4IBMS", cmd4IBMSxmlInfo)
            setItem(context, "cmd4Excel", cmd4ExcelxmlInfo)
    except :
        Log.error("Failed to execute prepare file, because %s" % str(traceback.format_exc()))
        return setResultFail(context, "prepare.fail.errMsg")
        
    return setResultSucc()


def get_ibms_file_name(context, product_model_version):
    ibms_file_name = COLLECT_CONFIG.IBMS_CONFIG_DICT.get(product_model_version, "cmd4IBMS.xml")
    flag, product_model, err_msg = get_internal_product_model(getCli(context), getLang(context))
    if not flag:
        Log.error(err_msg)
        return ibms_file_name
    if "OceanStor Micro" in product_model or "OceanDisk" in product_model:
        return COLLECT_CONFIG.MICRO_IBMS
    if product_model in config.DORADO_DEVS_V6:
        return COLLECT_CONFIG.DORADO_DEV_IBMS
    return ibms_file_name


def initLog(context):
    Log(context)
       
def parseCmd4IBMSxmlFile(context,parse_File):
    isSuccess = True
    cmd4IBMSxmlInfo = None
    try:
        cmd4IBMSxmlFile = os.path.join(context.get("path"), "script", "config", "%s" % parse_File)
        cmd4IBMSxmlInfo = parseXMLFile(cmd4IBMSxmlFile)
    except :
        isSuccess = False
        Log.error("Failed to parse xml file, because %s" % str(traceback.format_exc()))
    finally:
        return (isSuccess, cmd4IBMSxmlInfo)
    
def parseCmd4ExcelxmlFile(context,parse_File):
    isSuccess = True
    cmd4ExcelxmlInfo = None
    try:
        cmd4ExcelxmlFile = os.path.join(context.get("path"), "script", "config", "%s" % parse_File)
        cmd4ExcelxmlInfo = parseXMLFile(cmd4ExcelxmlFile)
    except :
        isSuccess = False
        Log.error("Failed to parse xml file, because %s" % str(traceback.format_exc()))
    finally:
        return (isSuccess, cmd4ExcelxmlInfo)


def canExecCliCmd(context):
    (isSuccess, cliRet, errMsg) = excuteCmd(context, CMD.SHOW_SYSTEM_GENERAL)
    dictList = getVerticalCliRet(cliRet)
    if dictList == [] or dictList[0]["System Name"] == "":
        return False
    return True


RE_CONNECTION_TIMES = 3
def checkConnection(context):
    cliConnection = None
    errMsg = ""
    
    connectorFactory = getConnectorFactoryObj(context)
    devObj = getDevObj(context)
    
    reConnectionTimes = 0
    while cliConnection is None and reConnectionTimes < RE_CONNECTION_TIMES:
        sshConnector = connectorFactory.createSshForwardConnector(devObj)
        try:
            cliConnection = sshConnector.getConnectionForPwdWillExpireBreak()
        except PwdException, ex:
            Log.error("checkConnection failed, because the password expire!")
            errMsg = ex.getErrorMsg()
            return False, errMsg
        except:
            lang = getLang(context)
            errMsg = getMsg(lang, "dev.conn.failure")
        finally:
            reConnectionTimes += 1
            
    if cliConnection is None:
        Log.error("checkConnection failed, because can not create cli connection!")
        return False, errMsg
    
    else:
        Log.info("checkConnection success!")
        return True, errMsg

          
USER_NAME_BLACK_LIST = ["developer", "diagnose", "error", "password", "upgrade", "minisystem", "storage"]
def checkLoginUserName(loginUserName):
    '''
    @summary: 检查工具登录用户名称是否为特殊用户名
    '''
    
    loginUserName = loginUserName.lower()
    
    for keyWords in USER_NAME_BLACK_LIST:
        if loginUserName.endswith(keyWords):
            return False
    
    return True

def checkLoginAdministrator(context,loginUserName):
    '''
    @summary: 检查用户是否为备份管理员（备份管理员进行限制收集）
    '''
    cmd = "show user user_name=%s" % (loginUserName)
    (isSuccess, cliRet, errMsg) = excuteCmd(context, cmd)
    if not isSuccess:
        return setResultFail(context, "systemStatus.abmormal.errMsg")
    DictList = getHorizontalCliRet(cliRet)
    Log.info("Dict is %s" % str(DictList))
    RoleId = ""
    for item in DictList:
        if "Role ID" in item:
            RoleId = item["Role ID"]
            Log.info("RoleId is %s" % str(RoleId))
        
    if RoleId == "9":
        return False
    
    return True 