# -*- coding: UTF-8 -*-
from common.commonFunction import checkSystemNormal,checkUserPrivilege,isExistCmdForRec,downloadFile,getHorizontalCliRet,getVerticalCliRet,getCurrentVersionAndPatchVerion
from frame.context.contextUtil import  getCli, getLang ,getSftp
from common.constant import CONFIG
from common.result import setResultFail,setResultSucc
import traceback
from common.log import Log
from common.commonFunction import excuteCmd


def execute(context):
    try:
        #收集前检查
        #检查系统是否正常
        isSysNormal ,errMsg = checkSystemNormal(context)
        if not isSysNormal:
            return False ,errMsg
        
        #检查用户级别是否满足收集信息
        isPrivilege ,errMsg = checkUserPrivilege(context)
        if not isPrivilege:
            return False , errMsg

        # 未安装对应补丁，且启动器数量超过80个或控制器不正常，限制收集。
        currentSoftVersion, currentHotpatchVersion = getCurrentVersionAndPatchVerion(context)
        flag, needInstallHotpatchVersion = isRiskVersionFcCauseRisk(context, currentSoftVersion,
                                                                    currentHotpatchVersion)
        if flag:
            return setResultFail(context, "install.fc.driver.risk.patch", needInstallHotpatchVersion)

        #执行收集Config.TXT文件的业务流程
        tempCmd = "show file export_path file_type=%s" % (CONFIG.EXPORT_TYPE_RUNNING_DATA)
        Log.info("execute collect : %s" % str(tempCmd))            
       
        isSuccess,cliRet ,errMeg = excuteCmd(context,tempCmd)
        if not isSuccess:
            return False ,errMeg   
        
        existCmd = isExistCmdForRec(cliRet)
        if not existCmd:
        #命令不存在，表示环境版本过低，直接收集成功
            Log.info("commend not exist %s" % str(cliRet))
            return True ,""
        
        #下载文件
        loadSucc = downloadFile(context, CONFIG.EXPORT_TYPE_RUNNING_DATA, cliRet)
        if not loadSucc:
            return setResultFail(context,"downLoad.file.failure")
            Log.info( "download file failed, and delete file")
                
        
        return setResultSucc()
                
    except Exception:
        Log.error("Failed to execute collectStandard file, because %s" % str(traceback.format_exc()))
        return setResultFail(context, "collect.fail.msg.runningdata")
    
    
def isRiskVersionFcCauseRisk(context, currentSoftVersion, currentHotpatchVersion):
    '''
    @summary: 工具规避在收集日志时触发的问题
    @param softwareVersionList: 当前阵列的版本所有控制器的版本列表
    @param hotPatchVersionList: 当前阵列的版本所有控制器的补丁版本列表
    retrun：False：表示是风险版本
            True：表示不是风险版本
    '''

    # 系统版本及热补丁风险版本
    riskVersionDict = {
        'V300R006C20': 'V300R006C20SPH015',
        'V300R006C20SPC100': 'V300R006C20SPH115',
        'V500R007C10': 'V500R007C10SPH015',
        'V500R007C30SPC100': 'V500R007C30SPH105',
        'V300R001C21SPC100': 'V300R001C21SPH112',
        'V500R007C10SPC100': 'V500R007C10SPH115',
        'V300R002C10SPC100': 'V300R002C10SPH101',
        'V300R006C50SPC100': 'V300R006C50SPH105',
        'V300R001C30SPC100': 'V300R001C30SPH106'
    }

    # 对版本型号及热补丁版本进行适配,如果系统版本不涉及则通过
    if currentSoftVersion not in riskVersionDict:
        return False, ''

    needInstallHotpatchVersion = riskVersionDict.get(currentSoftVersion)
    # 如果热补丁版本匹配则通过
    if currentHotpatchVersion != '--' and currentHotpatchVersion >= needInstallHotpatchVersion:
        return False, ''

    # 如果热补丁版本不匹配
    Log.info("hot patch version is lower than request")

    # 需判断启动器数量和控制器冗余
    cmd = "show initiator initiator_type=FC"
    (__, cliRet, __) = excuteCmd(context, cmd)
    iniDictList = getHorizontalCliRet(cliRet)
    normalInitiatorCount = 0
    for iniDict in iniDictList:
        if iniDict.get("Running Status", '') == "Online":
            normalInitiatorCount += 1

    isAllCtrlNormal = True
    cmd = "show controller general |filterColumn include columnList=Health\sStatus,Running\sStatus,Controller"
    (__, cliRet, __) = excuteCmd(context, cmd)
    controllerDictList = getVerticalCliRet(cliRet)
    for controllerDict in controllerDictList:
        if controllerDict.get("Health Status", '') != "Normal":
            isAllCtrlNormal = False
            break

        if controllerDict.get("Running Status", '') != "Online":
            isAllCtrlNormal = False
            break

    Log.info("hot patch version is lower than request, normal fc Initiator Count:%s, isAllCtrlNormal:%s" % (
                  normalInitiatorCount, isAllCtrlNormal))

    if normalInitiatorCount <= 200 and isAllCtrlNormal:
        return False, ''

    # 未安装对应补丁，且启动器数量超过80个或控制器不正常，限制收集。
    return True, needInstallHotpatchVersion