# -*- coding: UTF-8 -*-
from funcFactory.dataCollectUtil import collectData
from common.log import Log
from frame.cli.cliUtil import getProductModel
from common.commonFunction import getTitleFromXmInfo
from frame.context.contextUtil import getItem, initCliConnection, getCli, getLang
from common.constant import PRODUCT_MODEL
from common.result import setResultFail
import traceback
from funcFactory.cliParser import parse_transverseTable


def execute(context):
    try:
        #构造收集项的title
        setTitleData(context)
        #构造收集项的收集数据
        return setRetData(context)
    except Exception, ex:
        Log.error("Failed to execute collectStandard file, because %s" % str(traceback.format_exc()))
        return setResultFail(context, "collect.standard.fail.errMsg")


def setTitleData(context):
    cmd4IBMS = getItem(context, "cmd4IBMS")
    titleListMap = getTitleFromXmInfo(cmd4IBMS)
    context["titleListMap"] = titleListMap
    
    
def setRetData(context):
    cmd4IBMS = getItem(context, "cmd4IBMS")
    (code, retDataMap, allErrMsg) = collectData(context, cmd4IBMS)
    #对cli返回的原始数据进行处理
    resultHandle(context, retDataMap)
    context["retDataMap"] = retDataMap
    return (code, "", allErrMsg)


def resultHandle(context, retDataMap):
    # 获取产品型号
    initCliConnection(context)
    cli = getCli(context)
    lang = getLang(context)
    (isSucess, productModel, errMsg) = getProductModel(cli, lang)

    rackLocationList, shelfLocationDict = getRackAndShelfLocation(context)

    for oneDataKey in retDataMap:
        if oneDataKey == "Enclosure":
            handle_enclosure_info(oneDataKey, retDataMap, shelfLocationDict)
        # 从软件信息中获取一条不为空的数据
        if oneDataKey == "Software":
            handle_software_info(oneDataKey, retDataMap)
        # license
        if oneDataKey == "License":
            handle_license_info(oneDataKey, retDataMap)
        # Rack
        if oneDataKey == "Rack":
            handle_rack_info(oneDataKey, rackLocationList, retDataMap)
        # Dimension
        if oneDataKey == "Dimension":
            handle_dimension_info(oneDataKey, retDataMap)
        if oneDataKey == "Device":
            data_list = retDataMap.get(oneDataKey)
            for data_map in data_list:
                handle_device_info(data_map)
                remove_device_invalid_data(data_map)
                data_map["Device SN"] = data_map.get("SN")
                data_map["Device Type"] = "Storage"
                data_map["ServerType"] = -1

    # 删除无效的数据（为空或--）
    removeInvalidData(retDataMap)

    return


def handle_device_info(data_map):
    sn = {"SN": data_map.get("SN")}
    for one_data_key in data_map:
        if not data_map.get(one_data_key):
            continue
        if one_data_key in ["SN", "System Name"]:
            continue
        if one_data_key == "PowerModule":
            handle_power_module_info(data_map, one_data_key)
        if one_data_key == "Disk":
            handle_disk_module_info(data_map, one_data_key)
        data_list = data_map.get(one_data_key)
        for one_data in data_list:
            one_data.update(sn)


def handle_power_module_info(data_map, one_data_key):
    new_data = []
    for data in data_map.get(one_data_key, []):
        if data.get("Health Status") == "No Input":
            continue
        if data.get("BarCode"):
            data["Serial Number"] = data.get("BarCode")
        new_data.append(data)
    data_map[one_data_key] = new_data


def handle_disk_module_info(data_map, one_data_key):
    new_data = []
    for data in data_map.get(one_data_key, []):
        if data.get("BarCode"):
            data["Serial Number"] = data.get("BarCode")
        new_data.append(data)
    data_map[one_data_key] = new_data


def remove_device_invalid_data(data_map):
    for one_data_key in data_map:
        if not data_map.get(one_data_key):
            continue
        if one_data_key in ["SN", "System Name"]:
            continue
        data_list = data_map.get(one_data_key)
        new_data_list = []
        for one_data in data_list:
            remove_invalid_data(new_data_list, one_data)
        data_map[one_data_key] = new_data_list


def remove_invalid_data(new_data_list, one_data):
    new_one_data = {}
    for cli_key, cli_value in one_data.items():
        if not is_null(cli_value):
            new_one_data[cli_key] = cli_value
    new_data_list.append(new_one_data)


def handle_dimension_info(oneDataKey, retDataMap):
    enclTypeNumDict = {}
    dataList = retDataMap.get(oneDataKey)
    # 统计不同逻辑类型的框的数量
    for oneData in dataList:
        logicType = oneData.get("Logic Type")
        enclTypeNumDict[logicType] = enclTypeNumDict.get(logicType, 0) + 1
    # 设置量纲信息
    dataList = []
    for logicType in enclTypeNumDict:
        dimensionDict = {}
        dimensionDict['Type'] = logicType
        dimensionDict['Num'] = str(enclTypeNumDict.get(logicType))
        dataList.append(dimensionDict)
        retDataMap[oneDataKey] = dataList


def handle_rack_info(oneDataKey, rackLocationList, retDataMap):
    if not rackLocationList:
        retDataMap[oneDataKey] = [{"Location": "rack=-1"}]
        return
    retDataMap[oneDataKey] = [{"Location": rackLocation} for rackLocation in rackLocationList]


def handle_license_info(oneDataKey, retDataMap):
    dataList = retDataMap.get(oneDataKey)
    if not dataList:
        dataMap = {"License SN": "NA", "LICENSE SERVICE AUTH TYPE": "NA"}
        retDataMap[oneDataKey] = [dataMap]
    else:
        for oneData in dataList:
            LicenseSN = oneData.get("License SN")
            if is_null(LicenseSN):
                oneData["License SN"] = "NA"
            LicenseServiceType = oneData.get("LICENSE SERVICE AUTH TYPE")
            if is_null(LicenseServiceType):
                oneData["LICENSE SERVICE AUTH TYPE"] = "NA"


def handle_software_info(oneDataKey, retDataMap):
    dataList = retDataMap.get(oneDataKey)
    filteResult = None
    filteResult = dataList[0] if not dataList else {"Current Version": "NA", "Type": "NA", "patchVersion": "NA"}
    for oneData in dataList:
        softWareVersion = oneData.get("Current Version")
        if not is_null(softWareVersion):
            filteResult = oneData
            break
    retDataMap[oneDataKey] = [] if not filteResult else [filteResult]


def handle_enclosure_info(oneDataKey, retDataMap, shelfLocationDict):
    dataList = retDataMap.get(oneDataKey)
    for oneData in dataList:
        ID = oneData["ID"]
        safeDate = "rack=-1,shelf={}".format(ID)
        shelfLocation = shelfLocationDict.get(ID, safeDate)
        oneData['Location'] = shelfLocation


def removeInvalidData(retDataMap):
    #删除无效的数据（为空或--）
    for oneDataKey in retDataMap:
        dataList = retDataMap[oneDataKey]
        newDataList = []
        for oneData in dataList:
            newOneData = {}
            for cliKey in oneData:
                cliValue = oneData[cliKey]
                if cliValue not in ["", "--"]:
                    newOneData[cliKey] = cliValue      
            newDataList.append(newOneData)
        retDataMap[oneDataKey] = newDataList
        
    return

def getRackAndShelfLocation(context):
    
    rackLocationList = []
    shelfLocationDict = {}
    
    command = "show enclosure |filterColumn include columnList=ID,Location"
    (isSuccess, dictList, cliRet, errMsg) = parse_transverseTable(context, command)

    for dict in dictList:
        shelfID = dict.get("ID")
        rackLocation = dict.get("Location")
        if rackLocation not in ["--", ""]:
            rackLocation = "rack=%s" % rackLocation.split(".")[0]
            if rackLocationList.count(rackLocation) == 0:
                rackLocationList.append(rackLocation)
            shelfLocation = "%s,shelf=%s" % (rackLocation, shelfID)
            shelfLocationDict.setdefault(shelfID, shelfLocation)
        else:
            if rackLocationList.count("rack=-1") == 0:
                rackLocationList.append("rack=-1")
            shelfLocation = "rack=-1,shelf=%s" % shelfID
            shelfLocationDict.setdefault(shelfID, shelfLocation)
        
    return (rackLocationList, shelfLocationDict)


def is_null(value):
    return value in ["", "--"]
