# -*- coding: UTF-8 -*-
from frame.cli.cliUtil import get_horizontal_cli_ret, get_vertical_cli_ret
from utils.common_function_util import execute_cmd
from utils.log_util import Log


def log_when_cli_execute_failed(command, err_msg, cli_ret):
    Log.error("execute cli %s failed, because %s, and the cli return is %s" % (command, err_msg, cli_ret))


def get_info_by_cli_parser(context, command, cli_type, collect_item_title_list):
    """
    @summary: 调用cli解析器获取cli回显，并过滤出collectItemTitleList中的内容
    @param command: cli命令
    @param cli_type: cli命令回显结构
    @param collect_item_title_list: 获取的cli回显的字典
    @return: (cli命令，cli类型，需要获取的回显字段)
    """
    cli_parser_name = "parse_%s" % cli_type
    cli_parser = globals()[cli_parser_name]
    # 根据cmd4IBMS.xml<cmd><baseCmd>节点中配置的cli命令自动调用cliParser.py中的同名方法来收集数据
    is_success, dict_list = cli_parser(context, command)
    if not (is_success and dict_list):
        return is_success, dict_list

    # 根据cmd4IBMS.xml<str>节点中配置的收集数据从cli回显中筛选出最终的数据
    dict_list = ret_data_filter(dict_list, collect_item_title_list)
    return is_success, dict_list


def ret_data_filter(all_data, filt_data):
    """
    @summary: 筛选完整的cli回显中包含在<attr>节点中的数据
    @param all_data: cli回显(一个字典列表)
    @param filt_data: <attr>节点中配置的收集数据
    @return: 收集项的数据（一个字典列表）
    """
    for one_data in all_data:
        one_data_keys = one_data.keys()
        for key in one_data_keys:
            if key not in filt_data:
                one_data.pop(key)

    return all_data


def get_version_cli_ret(context, command, version_type):
    """
    @summary: 执行show version all命令回显，并根据versionType解析不同类型的version
    """
    is_success, cli_ret, err_msg = execute_cmd(context, command)
    if not is_success:
        log_when_cli_execute_failed(command, err_msg, cli_ret)
        return is_success, None

    controller_version_index = cli_ret.find("Controller:")
    expansion_version_index = cli_ret.find("Expansion Module:")
    bbu_version_index = cli_ret.find("BBU:")

    dict_list = []
    if version_type == "productVersion":
        cli_ret = cli_ret[:controller_version_index]
        dict_list = get_vertical_cli_ret(cli_ret)
    if version_type == "controllerVersion":
        cli_ret = cli_ret[controller_version_index:expansion_version_index]
        dict_list = get_vertical_cli_ret(cli_ret)
    if version_type == "expansionVersion":
        cli_ret = cli_ret[expansion_version_index:bbu_version_index]
        dict_list = get_horizontal_cli_ret(cli_ret)
    if version_type == "bbuVersion":
        cli_ret = cli_ret[bbu_version_index:]
        dict_list = get_horizontal_cli_ret(cli_ret)

    # cli执行成功，但cli解析为空，即cli未获取到信息
    if not dict_list:
        dict_list = None
    return is_success, dict_list


def parse_product_version(context, command):
    """
    @summary: 执行show version all命令回显，获取product Version
    """
    version_type = "productVersion"
    return get_version_cli_ret(context, command, version_type)


def parse_controller_version(context, command):
    """
    @summary: 执行show version all命令回显，controller Version
    """
    version_type = "controllerVersion"
    return get_version_cli_ret(context, command, version_type)


def parse_expansion_version(context, command):
    """
    @summary: 执行show version all命令回显，expansion Version
    """
    version_type = "expansionVersion"
    return get_version_cli_ret(context, command, version_type)


def parse_bbu_version(context, command):
    """
    @summary: 执行show version all命令回显，bbu Version
    """
    version_type = "bbuVersion"
    return get_version_cli_ret(context, command, version_type)
