# -*- coding: UTF-8 -*-

from frame.cli.cliUtil import execute_cmd_in_cli_mode, execute_cmd_in_developer_mode
from frame.context.contextUtil import init_cli_connection, get_cli, get_lang


def execute_cmd(context, command):
    init_cli_connection(context)
    cli = get_cli(context)
    lang = get_lang(context)
    return execute_cmd_in_cli_mode(cli, command, True, lang)


def execute_cmd_in_developer(context, command):
    init_cli_connection(context)
    cli = get_cli(context)
    lang = get_lang(context)
    return execute_cmd_in_developer_mode(cli, command, True, lang)


def get_title_from_xm_info(xm_info):
    """
    @summary: 从xml信息中解析出收集项中对应的cli回显中的字段
    @param xm_info: 解析xml后的信息(一个嵌套的字典)
    @return: 收集项的title（一个字典列表）
    """
    std_item_title_list_map = {}
    collect_item_nodes = xm_info["elementChildEles"]

    for collect_item_node in collect_item_nodes:
        collect_item_name = collect_item_node["elementAttrbutes"]["name"]
        cmd_nodes = collect_item_node["elementChildEles"]

        std_item_title_list = []
        for cmd_node in cmd_nodes:
            if cmd_node["elementName"] != "cmd":
                continue

            cmd_node_ele_0 = cmd_node["elementChildEles"][0]
            node_ele_attrs = cmd_node_ele_0["elementChildEles"]
            for node_ele_attr in node_ele_attrs:
                collect_text = node_ele_attr["elementText"]
                std_item_title_list.append(collect_text)

        std_item_title_list_map[collect_item_name] = std_item_title_list

    return std_item_title_list_map
