# -*- coding: UTF-8 -*-
import re

from pymodule.packages.utils.device_series_util import CLI_EXECUTE_CMD_SUCCESS


def is_chinese(lang):
    """
    @summary: 判断lang是否为中文
    @param lang: 语言lang
    @return:
        True: 中文
        False: 非中文
    """
    return lang == "zh"


def is_none_license(cli_ret):
    """
    @summary: 判断回显结果里面是否包含需要license
    @param cli_ret: cli回显
    @return:
        True: cli回显包含需要license
        False: cli回显不包含需要license
    """
    cli_ret_list = cli_ret.splitlines()
    for line in cli_ret_list:
        lower_line = line.lower()
        if "license" in lower_line and ("error" in lower_line or "suggestion" in lower_line):
            return True

    return False


def query_result_with_no_record(cli_ret):
    """
    @summary: 判断回显是否为Command executed successfully
    @param cli_ret: cli回显
    @return:
        True: cli回显中包含Command executed successfully
        False: cli回显中不包含Command executed successfully
    """
    if re.search(CLI_EXECUTE_CMD_SUCCESS, cli_ret, re.IGNORECASE):
        return True
    return False


def is_internal_error(cli_ret):
    """
    @summary: 判断回显结果是否包含内部错误信息
    @param cli_ret: cli回显
    @return:
        True: cli回显包含内部错误信息
        False: cli回显不包含内部错误信息
    """
    lower_cli_ret = cli_ret.lower()
    return "internal error" in lower_cli_ret
