/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cms.verify.bc;

import com.huawei.cms.verify.bc.CertWrapper;
import com.huawei.cms.verify.bc.CmscbbErr;
import com.huawei.cms.verify.bc.CommonUtil;
import com.huawei.cms.verify.bc.CrlWrapper;
import java.security.GeneralSecurityException;
import java.security.cert.CertPathBuilderException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.util.CollectionStore;

public final class CMSVerifyUtil {
    private CMSVerifyUtil() {
    }

    public static void checkCAOfCrl(X509Certificate baseCheckCert, CollectionStore<X509CertificateHolder> tspCerts, Date date, List<CertWrapper> certMap, Map<X500Principal, CrlWrapper> crlMap) throws GeneralSecurityException, AnnotatedException {
        X509Certificate uncheckedCert = baseCheckCert;
        while (true) {
            X509CRL crl;
            if ((crl = (X509CRL)CMSVerifyUtil.getCRLFromCAIssuer(uncheckedCert, crlMap).orElse(null)) == null) {
                throw new AnnotatedException("No crl issuered by " + uncheckedCert.getIssuerX500Principal().getName() + " is found.");
            }
            if (date.after(crl.getNextUpdate())) {
                throw new CertPathBuilderException(CmscbbErr.PKI_CERT_DATETIME_EXPIRED.toString());
            }
            X509Certificate issuerCert = CommonUtil.getSignCert(tspCerts, crl.getIssuerX500Principal(), certMap);
            CommonUtil.checkCAUsage(issuerCert);
            crl.verify(issuerCert.getPublicKey());
            X509CRLEntry crlEntry = crl.getRevokedCertificate(uncheckedCert);
            if (crlEntry != null) {
                if (CommonUtil.checkRevokeReason(crlEntry.getRevocationReason()) != CmscbbErr.OK) {
                    throw new AnnotatedException("Certificate has revoked");
                }
                if (crlEntry.getRevocationDate().before(date)) {
                    throw new AnnotatedException("CRL revoke date is before timestamp date");
                }
            }
            if (crl.getThisUpdate().before(issuerCert.getNotBefore()) || crl.getThisUpdate().after(issuerCert.getNotAfter())) {
                throw new CertPathBuilderException("CRL issue time is not in the period of validity of issuer.");
            }
            if (crl.getNextUpdate().before(date)) {
                throw new AnnotatedException("Crl issuerd by" + uncheckedCert.getIssuerX500Principal().getName() + " is not valid.");
            }
            if (CommonUtil.isSelfIssued(issuerCert)) break;
            uncheckedCert = issuerCert;
        }
    }

    private static Optional<X509CRL> getCRLFromCAIssuer(X509Certificate cert, Map<X500Principal, CrlWrapper> crlMap) throws GeneralSecurityException {
        Optional<Map.Entry> crlWrapperEntry = crlMap.entrySet().stream().filter(entry -> ((X500Principal)entry.getKey()).equals(cert.getIssuerX500Principal())).findFirst();
        if (crlWrapperEntry.isPresent()) {
            return Optional.of(CommonUtil.coverte(((CrlWrapper)crlWrapperEntry.get().getValue()).getCrl()));
        }
        return Optional.empty();
    }

    public static void checkHashAlgo(AlgorithmIdentifier algOID, Set<AlgorithmIdentifier> algoSet) throws AnnotatedException {
        ASN1ObjectIdentifier algorithm = algOID.getAlgorithm();
        CommonUtil.checkAlgAlgorithm(algorithm.getId());
        for (AlgorithmIdentifier algo : algoSet) {
            if (!algo.getAlgorithm().equals((ASN1Primitive)algorithm)) continue;
            return;
        }
        throw new AnnotatedException("Algorithm is not in AlgorithmSet.");
    }

    public static void checkSigneddataOid(String algOID) throws AnnotatedException {
        if (!algOID.equals(PKCSObjectIdentifiers.signedData.getId())) {
            throw new AnnotatedException("signedData Oid error.");
        }
    }
}

