/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.certbase.utils;

import com.huawei.ism.tool.certbase.utils.CertificateValidator;
import com.huawei.ism.tool.certbase.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalTrustRootCertUtil {
    private static final Logger log = LoggerFactory.getLogger(LocalTrustRootCertUtil.class);
    private static final List<String> SUPPORT_CERT_SUFFIX = Arrays.asList("pem", "cer", "crt", "der", "p7b");

    public static KeyStore getTrustKeyStore(String certDirPathOrOneCertFilePath) {
        File certFile = new File(Normalizer.normalize(certDirPathOrOneCertFilePath, Normalizer.Form.NFKC));
        if (!certFile.exists()) {
            log.warn("the file path: {} is not exists, please check.", (Object)certDirPathOrOneCertFilePath);
            return null;
        }
        HashSet<X509Certificate> trustedCerts = new HashSet<X509Certificate>();
        if (certFile.isFile()) {
            return LocalTrustRootCertUtil.getTrustKeyStore(LocalTrustRootCertUtil.loadCert(certFile));
        }
        AcceptFilenameFilter filter = new AcceptFilenameFilter();
        File[] certFiles = certFile.listFiles(filter);
        if (null == certFiles) {
            return null;
        }
        for (File certItem : certFiles) {
            trustedCerts.addAll(LocalTrustRootCertUtil.loadCert(certItem));
        }
        return LocalTrustRootCertUtil.getTrustKeyStore(trustedCerts);
    }

    public static Set<X509Certificate> loadCerts(String certPath) {
        File certFile = FileUtils.getCanonicalFile(certPath);
        if (certFile == null) {
            log.error("Invalid cert path: {}", (Object)certPath);
            return Collections.emptySet();
        }
        if (certFile.isDirectory()) {
            return LocalTrustRootCertUtil.loadCertsFromDir(certFile);
        }
        if (SUPPORT_CERT_SUFFIX.contains(FilenameUtils.getExtension(certFile.getName()))) {
            return LocalTrustRootCertUtil.loadCert(certFile);
        }
        log.error("The input path [{}] is not cert path.", (Object)certPath);
        return Collections.emptySet();
    }

    private static Set<X509Certificate> loadCertsFromDir(File certDir) {
        File[] files = certDir.listFiles(new AcceptFilenameFilter());
        if (files == null || files.length == 0) {
            log.error("Not find cert file.");
            return Collections.emptySet();
        }
        return Arrays.stream(files).map(LocalTrustRootCertUtil::loadCert).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static Set<X509Certificate> loadCert(File certItem) {
        HashSet<X509Certificate> trustedCerts = new HashSet<X509Certificate>();
        try (FileInputStream certFile = new FileInputStream(certItem);){
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> x509Certs = certificateFactory.generateCertificates(certFile);
            for (X509Certificate x509Certificate : x509Certs) {
                x509Certificate.checkValidity();
                CertificateValidator.checkExtensions(x509Certificate);
                log.info("load crt correct.file name:{}", (Object)certItem.getName());
                trustedCerts.add(x509Certificate);
            }
        }
        catch (Exception e) {
            log.error("loadCert Exception error.", (Throwable)e);
        }
        return trustedCerts;
    }

    private static KeyStore getTrustKeyStore(Set<X509Certificate> trustedCerts) {
        KeyStore trustKeyStore = null;
        try {
            trustKeyStore = KeyStore.getInstance("JKS");
            trustKeyStore.load(null, null);
            int count = 1;
            for (Certificate certificate : trustedCerts) {
                trustKeyStore.setCertificateEntry("TurstCer" + count++, certificate);
            }
        }
        catch (Exception e) {
            log.error("initKeyStore by trustedCerts error.", (Throwable)e);
        }
        return trustKeyStore;
    }

    private LocalTrustRootCertUtil() {
    }

    private static class AcceptFilenameFilter
    implements FilenameFilter {
        private AcceptFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return SUPPORT_CERT_SUFFIX.contains(FilenameUtils.getExtension(name));
        }
    }
}

