/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.filter;

import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;

public class Fitable {
    private final String genericableId;
    private final String fitableId;
    private final List<String> aliases = new ArrayList<String>();
    private final boolean isDefault;

    public Fitable(String genericableId, String fitableId, List<String> aliases, boolean isDefault) {
        this.genericableId = Validation.notBlank((String)genericableId, (String)"No genericableId.", (Object[])new Object[0]);
        this.fitableId = Validation.notBlank((String)fitableId, (String)"No fitableId. [genericableId={0}]", (Object[])new Object[]{this.genericableId});
        List actualAliases = (List)Validation.notNull(aliases, (String)"No aliases. [genericableId={0}, fitableId={1}]", (Object[])new Object[]{this.genericableId, this.fitableId});
        this.aliases.addAll(actualAliases.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList()));
        Validation.greaterThan((int)this.aliases.size(), (int)0, (String)"No actual alias. [genericableId={0}, fitableId={1}]", (Object[])new Object[]{this.genericableId, this.fitableId});
        this.isDefault = isDefault;
    }

    public List<String> getAliases() {
        return Collections.unmodifiableList(this.aliases);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean containsAnyFitableId(List<String> fitableIds) {
        Validation.notNull(fitableIds, (String)"FitableIds is null.", (Object[])new Object[0]);
        return fitableIds.stream().filter(StringUtils::isNotBlank).anyMatch(fitableId -> Objects.equals(this.getFitableId(), fitableId));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Fitable)) {
            return false;
        }
        Fitable other = (Fitable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDefault() != other.isDefault()) {
            return false;
        }
        String this$genericableId = this.getGenericableId();
        String other$genericableId = other.getGenericableId();
        if (this$genericableId == null ? other$genericableId != null : !this$genericableId.equals(other$genericableId)) {
            return false;
        }
        String this$fitableId = this.getFitableId();
        String other$fitableId = other.getFitableId();
        if (this$fitableId == null ? other$fitableId != null : !this$fitableId.equals(other$fitableId)) {
            return false;
        }
        List<String> this$aliases = this.getAliases();
        List<String> other$aliases = other.getAliases();
        return !(this$aliases == null ? other$aliases != null : !((Object)this$aliases).equals(other$aliases));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Fitable;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDefault() ? 79 : 97);
        String $genericableId = this.getGenericableId();
        result = result * 59 + ($genericableId == null ? 43 : $genericableId.hashCode());
        String $fitableId = this.getFitableId();
        result = result * 59 + ($fitableId == null ? 43 : $fitableId.hashCode());
        List<String> $aliases = this.getAliases();
        result = result * 59 + ($aliases == null ? 43 : ((Object)$aliases).hashCode());
        return result;
    }

    @Generated
    public String getGenericableId() {
        return this.genericableId;
    }

    @Generated
    public String getFitableId() {
        return this.fitableId;
    }
}

