/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.filter.route;

import com.huawei.fitframework.broker.client.filter.Fitable;
import com.huawei.fitframework.broker.client.filter.route.AbstractFilter;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliasFilter
extends AbstractFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AliasFilter.class);
    private final List<String> aliases;

    public AliasFilter(String ... aliases) {
        this(Stream.of((Object[])ObjectUtils.getIfNull((Object)aliases, () -> new String[0])).collect(Collectors.toList()));
    }

    public AliasFilter(List<String> aliases) {
        this.aliases = ((List)ObjectUtils.getIfNull(aliases, Collections::emptyList)).stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        Validation.isTrue((boolean)CollectionUtils.isNotEmpty(this.aliases), (String)"No valid alias to instantiate AliasFilter.", (Object[])new Object[0]);
    }

    @Override
    protected List<Fitable> route(List<Fitable> toFilterFitables, Object[] args) {
        log.debug("Prepare to route by alias. [aliases={}, toFilterFitables={}]", this.aliases, toFilterFitables);
        List<Fitable> filteredFitables = toFilterFitables.stream().filter(this::containsAnyAlias).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filteredFitables)) {
            log.warn("Fail to route by alias. [aliases={}, toFilterFitables={}]", this.aliases, toFilterFitables);
        } else {
            log.debug("Route by alias successfully. [aliases={}, targetFitables={}]", this.aliases, filteredFitables);
        }
        return filteredFitables;
    }

    private boolean containsAnyAlias(Fitable fitable) {
        Set theSameAliases = CollectionUtils.intersect(fitable.getAliases(), this.aliases);
        return !theSameAliases.isEmpty();
    }
}

